/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.receivable.payment;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.NewNoteParser;
import kd.ebg.note.banks.abc.dc.service.newnote.receivable.QueryReceivableNoteImpl;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivablePaymentNoteImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceivableNoteImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CFRC61";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u4ed8\u6b3e", (String)"ReceivablePaymentNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CFRC61");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1011", "");
        Element BusiInf = JDomUtils.addChild((Element)hermes, (String)"BusiInf");
        JDomUtils.addChild((Element)BusiInf, (String)"AppDt", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)BusiInf, (String)"ApplyAmt", (String)receivableInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)BusiInf, (String)"BnedMtmrk", (String)receivableInfos[0].getTransferFlag());
        JDomUtils.addChild((Element)BusiInf, (String)"Note", (String)receivableInfos[0].getExplanation());
        Element StlInf = JDomUtils.addChild((Element)hermes, (String)"StlInf");
        JDomUtils.addChild((Element)StlInf, (String)"SetAmt", (String)receivableInfos[0].getAmount().toString());
        String payeeBankName = receivableInfos[0].getPayeeBankName();
        if ("1".equals(receivableInfos[0].getIsPayeeSameBank())) {
            JDomUtils.addChild((Element)StlInf, (String)"SetMode", (String)"ST02");
        } else {
            JDomUtils.addChild((Element)StlInf, (String)"SetMode", (String)"ST01");
        }
        JDomUtils.addChild((Element)StlInf, (String)"ClrTp", (String)receivableInfos[0].getClearType());
        JDomUtils.addChild((Element)StlInf, (String)"StlDt", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        Element CustInf = JDomUtils.addChild((Element)hermes, (String)"CustInf");
        JDomUtils.addChild((Element)CustInf, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)CustInf, (String)"AcctSvcr", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)CustInf, (String)"ConAcctSvcr", (String)"");
        Element BillInf = JDomUtils.addChild((Element)hermes, (String)"BillInf");
        JDomUtils.addChild((Element)BillInf, (String)"CdNo", (String)receivableInfos[0].getBillNo());
        JDomUtils.addChild((Element)BillInf, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange(receivableInfos[0].getStartNo()));
        JDomUtils.addChild((Element)BillInf, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange(receivableInfos[0].getEndNo()));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NewNoteParser.parse(bankNoteReceivableRequest, s);
        return bankNoteReceivableRequest.getNoteReceivableInfos();
    }
}

