/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.payable.register;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DCNoteResponse;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryRegisterNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRegisterNotePayableImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CQRM42";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u67e5\u8be2", (String)"QueryRegisterNotePayableImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfoList = request.getNotePayableInfoList();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRM42");
        Element hermes = CommNotePacker.packNoteHeader(root, "0018");
        NotePayableInfo info = (NotePayableInfo)notePayableInfoList.get(0);
        Element cmp = CommNotePacker.packCmpElement(root, acnt);
        JDomUtils.addChild((Element)hermes, (String)"RowStart", (String)"0");
        JDomUtils.addChild((Element)hermes, (String)"RowEnd", (String)"20");
        JDomUtils.addChild((Element)hermes, (String)"BatchNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)hermes, (String)"BillTyp", (String)info.getDraftType());
        JDomUtils.addChild((Element)hermes, (String)"InNb", (String)"");
        JDomUtils.addChild((Element)hermes, (String)"BillAmtFr", (String)"0.00");
        JDomUtils.addChild((Element)hermes, (String)"BillAmtFr", (String)"999999999.00");
        JDomUtils.addChild((Element)hermes, (String)"BillAmtSta", (String)"");
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        JDomUtils.addChild((Element)cme, (String)"ContLast");
        JDomUtils.addChild((Element)cme, (String)"ContFlag", (String)"0");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    private int getStatus(String statusCode) {
        if ("030006".equals(statusCode) || "100001".equals(statusCode) || "180001".equals(statusCode) || "110201".equals(statusCode) || "110101".equals(statusCode)) {
            return 1;
        }
        if ("020001".equals(statusCode) || "030001".equals(statusCode) || "010004".equals(statusCode) || "020006".equals(statusCode)) {
            return 0;
        }
        return -1;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfoList = request.getNotePayableInfoList();
        NotePayableInfo notePayableInfo = (NotePayableInfo)notePayableInfoList.get(0);
        this.parserNoteNo(notePayableInfoList, responseStr);
        return notePayableInfoList;
    }

    private void parserNoteNo(List<NotePayableInfo> infos, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        this.logger.info("respCode:" + rspCode);
        if (!"0000".equals(rspCode)) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            return;
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        String[] splits = new String[]{};
        Element cmp = root.getChild("Cmp");
        if ("1".equals(fileFlag)) {
            String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
            splits = ResponseFileUtils.getDetailRspRecords(fileName, "");
        } else {
            String respPrvData = ParserUtils.checkUnNullableElement((Element)cmp, (String)"RespPrvData");
            splits = StringUtils.split((String)respPrvData, (String)"|");
        }
        int fieldNum = Integer.parseInt(fieldNumStr);
        Map<String, ABC_DCNoteResponse> statusMap = this.getNoteStatusMap(splits, recordNum);
        this.logger.info("\u89e3\u6790\u7684key\u4e3a --");
        for (String key : statusMap.keySet()) {
            this.logger.info(key);
        }
        for (NotePayableInfo info : infos) {
            String key = info.getBankBatchSeqId();
            ABC_DCNoteResponse response = statusMap.get(key);
            if (null != response) {
                info.setNoteStatus(response.getNoteStatus());
                info.setBillNo(response.getBillNo());
                if (response.isSubmit()) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if (response.isFailed()) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if (response.isSuccess()) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
                continue;
            }
            this.logger.warn("\u672a\u8bc6\u522b\u7684key\uff1a" + key);
        }
    }

    private Map<String, ABC_DCNoteResponse> getNoteStatusMap(String[] splits, int recordNum) {
        HashMap<String, ABC_DCNoteResponse> result = new HashMap<String, ABC_DCNoteResponse>(1);
        for (int i = 0; i < recordNum; ++i) {
            String billNo = splits[i * recordNum];
            String noteStatus = splits[i * recordNum + 4];
            String bathNo = splits[i * recordNum + 5];
            String status = splits[i * recordNum + 8];
            String bankMsg = splits[i * recordNum + 9];
            ABC_DCNoteResponse response = new ABC_DCNoteResponse();
            response.setBillNo(billNo);
            response.setNoteStatus(noteStatus);
            response.setResponseMessage(status);
            String key = bathNo;
            int parseredStatus = this.getStatus(noteStatus);
            if (parseredStatus == 1) {
                response.setSuccess(true);
            } else if (parseredStatus == -1) {
                response.setFailed(true);
            } else {
                response.setSubmit(true);
            }
            result.put(key, response);
        }
        return result;
    }

    public int getBatchSize() {
        return 0;
    }
}

