/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CFRT51";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968(CFRT51)", (String)"RegisterNotePayableImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        List infos = request.getNotePayableInfoList();
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT51");
        Element hermes = CommNotePacker.packNoteHeader(root, "0010");
        NotePayableInfo info = (NotePayableInfo)infos.get(0);
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(info.getDrawerAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        if (MatchUtils.isSameBank(EBContext.getContext().getBankVersionID(), info.getPayeeBankName()) && info.getPayeeAccNo().length() == 15) {
            String areaCode = MatchUtils.getAreaCode(info);
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)(areaCode + info.getPayeeAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)areaCode);
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)info.getPayeeAccNo());
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        JDomUtils.addChild((Element)root, (String)"Amt", (String)info.getAmount().setScale(2).toString());
        Element ebinfo = JDomUtils.addChild((Element)hermes, (String)"EBInfo");
        JDomUtils.addChild((Element)ebinfo, (String)"BillTyp", (String)info.getDraftType());
        String testServerDate = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        if (StringUtils.isEmpty((String)testServerDate)) {
            JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
        } else {
            JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)testServerDate);
        }
        String duedate = info.getDueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)ebinfo, (String)"DueDat", (String)duedate);
        JDomUtils.addChild((Element)ebinfo, (String)"TransFlg", (String)info.getTransferFlag());
        Element billInfo = JDomUtils.addChild((Element)hermes, (String)"BillInfo");
        if ("1".equals(info.getAutoAccept())) {
            JDomUtils.addChild((Element)billInfo, (String)"DuePayTyp", (String)"CC00");
        } else {
            JDomUtils.addChild((Element)billInfo, (String)"DuePayTyp", (String)"CC01");
        }
        JDomUtils.addChild((Element)billInfo, (String)"BatchNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)billInfo, (String)"ContNo", (String)"");
        JDomUtils.addChild((Element)billInfo, (String)"InvoiceNo", (String)"");
        JDomUtils.addChild((Element)billInfo, (String)"Object", (String)"");
        Element drawerInfo = JDomUtils.addChild((Element)hermes, (String)"DrawerInfo");
        JDomUtils.addChild((Element)drawerInfo, (String)"FrTyp", (String)"RC01");
        JDomUtils.addChild((Element)drawerInfo, (String)"FrNam", (String)acnt.getAccName());
        JDomUtils.addChild((Element)drawerInfo, (String)"FrOpBnk", (String)info.getDrawerBankCnaps());
        JDomUtils.addChild((Element)drawerInfo, (String)"FrOpBnkNam", (String)info.getDrawerBankName());
        Element accepterInfo = JDomUtils.addChild((Element)hermes, (String)"AccepterInfo");
        if ("AC01".equals(info.getDraftType())) {
            JDomUtils.addChild((Element)accepterInfo, (String)"AcepAccNo", (String)"0");
        } else {
            JDomUtils.addChild((Element)accepterInfo, (String)"AcepAccNo", (String)info.getAcceptorAccNo());
        }
        JDomUtils.addChild((Element)accepterInfo, (String)"AcepNam", (String)info.getAcceptorAccName());
        JDomUtils.addChild((Element)accepterInfo, (String)"AcepOpBnk", (String)info.getAcceptorBankCnaps());
        JDomUtils.addChild((Element)accepterInfo, (String)"AcepOpBnkNam", (String)info.getAcceptorBankName());
        Element payeeInfo = JDomUtils.addChild((Element)hermes, (String)"PayeeInfo");
        JDomUtils.addChild((Element)payeeInfo, (String)"ToNam", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)payeeInfo, (String)"ToOpBnk", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)payeeInfo, (String)"ToOpBnkNam", (String)info.getPayeeBankName());
        JDomUtils.addChild((Element)hermes, (String)"IsAutoPromptBill", (String)"Y");
        JDomUtils.addChild((Element)hermes, (String)"Note", (String)info.getExplanation());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        CommNotePacker.parserNotePay(notePayableInfos, responseStr);
        return notePayableInfos;
    }
}

