/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.note.receivable.endorse;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.note.receivable.endorse.QueryEndorseNoteReceivableImpl;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class EndorseNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryEndorseNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "CFRT55";
    }

    public String getBizCode() {
        return "CFRT55";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7535\u7968\u80cc\u4e66(CFRT55)", (String)"EndorseNoteReceivableImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT55");
        Element hermes = CommNotePacker.packNoteHeader(root, "0100");
        Element cmp = CommNotePacker.packCmpElement(root, acnt);
        if (MatchUtils.isSameBank(info) && info.getPayeeAccNo().length() == 15) {
            String areaCode = MatchUtils.getAreaCode(info);
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)(areaCode + info.getPayeeAccNo()));
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)areaCode);
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)info.getPayeeAccNo());
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        JDomUtils.addChild((Element)root, (String)"Amt", (String)info.getAmount().toString());
        Element ebinfo = JDomUtils.addChild((Element)hermes, (String)"EBInfo");
        JDomUtils.addChild((Element)ebinfo, (String)"IdNb", (String)info.getBillNo());
        JDomUtils.addChild((Element)ebinfo, (String)"BillTyp", (String)info.getDraftType());
        JDomUtils.addChild((Element)ebinfo, (String)"TransFlg", (String)info.getTransferFlag());
        String IssDat = info.getIssueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String duedate = info.getDueDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        JDomUtils.addChild((Element)ebinfo, (String)"IssDat", (String)IssDat);
        JDomUtils.addChild((Element)ebinfo, (String)"DueDat", (String)duedate);
        JDomUtils.addChild((Element)hermes, (String)"BatchNo", (String)info.getBankBatchSeqId());
        Element endrsee = JDomUtils.addChild((Element)hermes, (String)"Endrsee");
        JDomUtils.addChild((Element)endrsee, (String)"EseNam", (String)info.getPayeeAccName());
        JDomUtils.addChild((Element)endrsee, (String)"EseOpBnk", (String)info.getPayeeBankCnaps());
        JDomUtils.addChild((Element)endrsee, (String)"EseOpBnkNam", (String)info.getPayeeBankName());
        Element endrsr = JDomUtils.addChild((Element)hermes, (String)"Endrsr");
        JDomUtils.addChild((Element)endrsr, (String)"EsrTyp", (String)"RC01");
        JDomUtils.addChild((Element)endrsr, (String)"EsrConBnk", (String)"");
        JDomUtils.addChild((Element)endrsr, (String)"EsrConBnkNam", (String)"");
        JDomUtils.addChild((Element)endrsr, (String)"EsrNam", (String)acnt.getAccName());
        JDomUtils.addChild((Element)endrsr, (String)"EsrOpBnk", (String)acnt.getCnaps());
        JDomUtils.addChild((Element)endrsr, (String)"EsrOpBnkNam", (String)acnt.getBankName());
        JDomUtils.addChild((Element)hermes, (String)"Note", (String)info.getExplanation());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        CommNotePacker.parserNoteReq(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }
}

