/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.codeless;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CommonParser {
    public static void parsePayable(List<NotePayableInfo> infos, String rspStr) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if ("000000".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"%s\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"CommonParser_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), response.getResponseMessage()));
            Element TX_INFO = root.getChild("TX_INFO");
            if (infos.size() > 30) {
                String Btch_No = TX_INFO.getChildText("Btch_No");
                EBGNotePayableUtils.setBatchNo(infos, (String)Btch_No);
            } else if ("AC01".equals(infos.get(0).getDraftType())) {
                String BkListNo1 = TX_INFO.getChildText("STS_TRACE_ID");
                EBGNotePayableUtils.setBatchNo(infos, (String)BkListNo1);
                List info_grp = TX_INFO.getChildren("BkRspInfo_GRP");
                for (Element info : info_grp) {
                    String txnSrlNo = info.getChildText("TxnSrlNo");
                    String pltfrm_dt = info.getChildText("Pltfrm_Dt");
                    String Bl_Acpt_Agrm_Bl_No = info.getChildText("Bl_Acpt_Agrm_Bl_No");
                    for (NotePayableInfo payableInfo : infos) {
                        if (!Bl_Acpt_Agrm_Bl_No.equals(payableInfo.getBillNo())) continue;
                        payableInfo.setBankRefKey(txnSrlNo);
                        payableInfo.setBankRefDate(pltfrm_dt);
                    }
                }
            } else if ("AC02".equals(infos.get(0).getDraftType())) {
                String BkListNo1 = TX_INFO.getChildText("STS_TRACE_ID");
                EBGNotePayableUtils.setBatchNo(infos, (String)BkListNo1);
                String txnSrlNo = TX_INFO.getChildText("TxnSrlNo");
                String pltfrm_dt = TX_INFO.getChildText("Pltfrm_Dt");
                infos.get(0).setBankRefKey(txnSrlNo);
                infos.get(0).setBankRefDate(pltfrm_dt);
            }
        } else if ("YCEECDA65156".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }

    public static void parseIsrefuse(List<NoteReceivableInfo> infos) {
        for (NoteReceivableInfo info : infos) {
            String temp;
            String bankStatus = info.getBankStatus();
            if (!StringUtils.isNotEmpty((String)bankStatus) || !StringUtils.isNotEmpty((String)(temp = bankStatus.replaceAll("[^0-9]", "")))) continue;
            int i = Integer.parseInt(temp);
            if (i <= 10) {
                info.setIsRefuse("0");
                continue;
            }
            if (i <= 17) {
                info.setIsRefuse("1");
                continue;
            }
            if (i <= 23) {
                info.setIsRefuse("0");
                continue;
            }
            if (i >= 100) continue;
            info.setIsRefuse("1");
        }
    }
}

