/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.codeless.detail.endorseInfo;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.codeless.detail.endorseInfo.CodelessNoteDetailImpl;
import kd.ebg.note.banks.ccb.dc.services.codeless.detail.endorseInfo.NoteInfosImpl;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    public static final int PAGE_SIZE = 200;
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public boolean isPackerAuto() {
        return true;
    }

    public boolean isParserAuto() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isNeedPage() {
        return true;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"TOTAL_PAGE");
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                String curr_total_page = JDomUtils.getChildText((Element)txBody, (String)"CURR_TOTAL_PAGE");
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(curr_total_page);
                flag = page >= pageTotalNum;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    public String pack(BankNoteDetailRequest bankNoteDetailRequest, String s) {
        return null;
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "6WH242";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"NoteDetailImpl_9", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return !noteDetailRequest.getBody().getTranType().equals("40");
    }

    public long getBankInterval() {
        return 0L;
    }

    public String getStructIdPacker() {
        return "6WH242";
    }

    public List<Detail> getSideImpl(List<Detail> details) throws Exception {
        BankNoteDetailRequest request = new BankNoteDetailRequest();
        NoteInfosImpl impl = new NoteInfosImpl();
        BankHeader header = new BankHeader();
        header.setAcnt(EBContext.getContext().getAcnt());
        header.setSubBizType("reply");
        request.setHeader(header);
        for (Detail detail : details) {
            try {
                BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
                body.setStartNo(detail.getStartNo());
                body.setEndNo(detail.getEndNo());
                body.setNoteNo(detail.getNoteNo());
                body.setDraftType(detail.getDraftType());
                request.setBody(body);
                EBBankDetailResponse response = impl.doBiz(request);
                List noteSidesInfo = ((Detail)response.getDetails().get(0)).getNoteSidesInfo();
                detail.setNoteSidesInfo(noteSidesInfo);
            }
            catch (Exception e) {
                detail.setIsNoteSidesError("Y");
            }
        }
        return details;
    }

    public List<Detail> parserUtil(BankNoteDetailRequest request, String responStr) {
        List details = super.parserUtil(request, responStr);
        BankNoteDetailRequestBody body = request.getBody();
        BankNoteDetailRequest query = new BankNoteDetailRequest();
        CodelessNoteDetailImpl impl = new CodelessNoteDetailImpl();
        for (Detail info : details) {
            body.setNoteNo(info.getNoteNo());
            body.setStartNo(info.getStartNo());
            body.setEndNo(info.getEndNo());
            query.setHeader(request.getHeader());
            query.setBody(body);
            EBBankDetailResponse response = impl.doBiz(query);
            Detail payeeInfo = (Detail)response.getDetails().get(0);
            info.setDraftType(body.getDraftType());
            info.setPayeeAccNo(payeeInfo.getPayeeAccNo());
            info.setPayeeBankName(payeeInfo.getPayeeBankName());
            info.setPayeeCnapsCode(payeeInfo.getPayeeCnapsCode());
            info.setPayeeAccName(payeeInfo.getPayeeAccName());
            info.setBusinessCode(request.getBody().getTranType());
            info.setDrawerBankName(payeeInfo.getDrawerBankName());
        }
        return details;
    }

    public boolean isCodelessSide() {
        return true;
    }
}

