/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryNoteStatusParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryNoteStatusParser.class);

    public static void parseQueryPayable(List<NotePayableInfo> notePayableInfos, String rspStr) {
        NotePayableInfo notePayableInfo = notePayableInfos.get(0);
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!response.getResponseCode().equals("000000")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)notePayableInfo, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element txBody = root.getChild("TX_INFO");
            List lists = txBody.getChildren("LIST");
            block0: for (NotePayableInfo info : notePayableInfos) {
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                    if (BkListNo1.equals(info.getBillNo())) {
                        String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                        String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                        if (BkFlag2.equals("00")) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"QueryNoteStatusParser_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue block0;
                        }
                        if (BkFlag2.equals("22")) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                            continue block0;
                        }
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                        continue block0;
                    }
                    logger.info("\u8fd4\u56de\u7684\u65e5\u5fd7\u4e2d\u4e0d\u5305\u542b\u5f53\u524d\u7968\u53f7");
                }
            }
        }
    }

    public static void parseQueryPay(List<NoteReceivableInfo> infos, String rspStr) {
        NoteReceivableInfo noteReceivableinfo = infos.get(0);
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!response.getResponseCode().equals("000000")) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableinfo, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element txBody = root.getChild("TX_INFO");
            List lists = txBody.getChildren("LIST");
            block0: for (NoteReceivableInfo info : infos) {
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                    if (BkListNo1.equals(info.getBillNo())) {
                        String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                        String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                        if (BkFlag2.equals("00")) {
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"QueryNoteStatusParser_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue block0;
                        }
                        if (BkFlag2.equals("22")) {
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                            continue block0;
                        }
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                        continue block0;
                    }
                    logger.info("\u8fd4\u56de\u7684\u65e5\u5fd7\u4e2d\u4e0d\u5305\u542b\u5f53\u524d\u7968\u53f7");
                }
            }
        }
    }

    public static void parseQueryResponsePayable(List<NotePayableInfo> notePayableInfos, String rsp) {
        Element txbody;
        List list;
        NotePayableInfo info = notePayableInfos.get(0);
        Element header = CCB_DC_Parser.parseString2Root(rsp);
        BankResponse response = CCB_DC_Parser.parseResponse(header);
        if (!response.getResponseCode().equals("000000")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        if ((list = (txbody = header.getChild("TX_INFO")).getChildren("LIST")).size() == 0) {
            logger.info("\u8fd4\u56de\u7684\u8282\u70b9\u957f\u5ea6\u4e3a0");
        }
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Element element : list) {
            String BkListNo1 = element.getChildTextTrim("BkListNo1");
            String BkFlag2 = element.getChildTextTrim("BkFlag2");
            map.put(BkListNo1, BkFlag2);
        }
        String status = (String)map.get(info.getBillNo());
        if (status.equals("00")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u6210\u529f\u3002", (String)"QueryNoteStatusParser_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        } else if (status.equals("22")) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u5931\u8d25\u3002", (String)"QueryNoteStatusParser_2", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        } else {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5", (String)"QueryNoteStatusParser_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
        }
    }

    public static void parseQueryResponsePay(List<NoteReceivableInfo> receivableInfos, String rsp) {
        Element txbody;
        List list;
        NoteReceivableInfo info = receivableInfos.get(0);
        Element header = CCB_DC_Parser.parseString2Root(rsp);
        BankResponse response = CCB_DC_Parser.parseResponse(header);
        if (!response.getResponseCode().equals("000000")) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        if ((list = (txbody = header.getChild("TX_INFO")).getChildren("LIST")).size() == 0) {
            logger.info("\u8fd4\u56de\u7684\u8282\u70b9\u957f\u5ea6\u4e3a0");
        }
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Element element : list) {
            String BkListNo1 = element.getChildTextTrim("BkListNo1");
            String BkFlag2 = element.getChildTextTrim("BkFlag2");
            map.put(BkListNo1, BkFlag2);
        }
        String status = (String)map.get(info.getBillNo());
        if (status.equals("00")) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)"");
        } else if (status.equals("22")) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)"");
        } else {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)"");
        }
    }
}

