/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.noteinfo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.business.noteinfo.atomic.AbstractNoteInfoImpl;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoBody;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoRequest;
import kd.ebg.note.business.noteinfo.bank.EBBankNoteInfoResponse;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoDetail;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoRequest;
import org.jdom2.Element;

public class NoteInfoImpl
extends AbstractNoteInfoImpl {
    public String pack(BankNoteInfoRequest request) {
        Element root = CCB_DC_Packer.createTransactionHeader("6WH050", Sequence.gen16NumSequence() + "");
        Element txBody = NoteCommonPacker.createTransactionBody(root, "", "");
        BankNoteInfoBody detail = request.getBody();
        Element list = JDomUtils.addChild((Element)txBody, (String)"LIST");
        List noteInfoDetails = request.getBody().getDetails();
        for (NoteInfoDetail infoDetail : noteInfoDetails) {
            JDomUtils.addChild((Element)list, (String)"BkListNo1", (String)infoDetail.getNoteNo());
            JDomUtils.addChild((Element)list, (String)"BkAmt1", (String)infoDetail.getAmount());
            JDomUtils.addChild((Element)list, (String)"Bk10Date2", (String)infoDetail.getDueDate());
            JDomUtils.addChild((Element)list, (String)"BkType1", (String)"RM00");
            JDomUtils.addChild((Element)list, (String)"BkRate1", (String)infoDetail.getDiscountRate());
            JDomUtils.addChild((Element)list, (String)"Bk10Date1", (String)DateUtil.formatDate((Date)new Date()));
            if ("2".equals(infoDetail.getPayRateType())) {
                JDomUtils.addChild((Element)list, (String)"BkType2", (String)"2");
                JDomUtils.addChild((Element)list, (String)"BkAmt2", (String)"");
            } else if ("1".equals(infoDetail.getPayRateType())) {
                JDomUtils.addChild((Element)list, (String)"BkType2", (String)"1");
                JDomUtils.addChild((Element)list, (String)"BkAmt2", (String)"");
            } else {
                JDomUtils.addChild((Element)list, (String)"BkType2", (String)"3");
                JDomUtils.addChild((Element)list, (String)"BkAmt2", (String)infoDetail.getIncreaseRate());
            }
            JDomUtils.addChild((Element)list, (String)"BkHvpBrchNo", (String)infoDetail.getPayeeCnapsCode());
        }
        return NoteCommonPacker.root2StringSafeMod(root);
    }

    public EBBankNoteInfoResponse parse(BankNoteInfoRequest request, String responseStr) {
        Element root = CCB_DC_Parser.parseString2Root(responseStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        BankNoteInfoBody infoDetail = request.getBody();
        ArrayList<NoteInfoDetail> noteInfoDetails = new ArrayList<NoteInfoDetail>();
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            Element detaillist = JDomUtils.getChildElement((Element)txBody, (String)"DETAILLIST");
            List detailLists = detaillist.getChildren("DETAILINFO");
            for (Element detail : detailLists) {
                NoteInfoDetail detail1 = new NoteInfoDetail();
                String billNo = JDomUtils.getChildText((Element)detail, (String)"BkListNo1");
                detail1.setNoteNo(billNo);
                String amountStr = JDomUtils.getChildText((Element)detail, (String)"BkAmt3");
                detail1.setDiscountAmount(amountStr);
                String BkNum2 = JDomUtils.getChildText((Element)detail, (String)"BkNum2");
                detail1.setIntDaysAdjust(BkNum2);
                String BkNum3 = JDomUtils.getChildText((Element)detail, (String)"BkNum3");
                detail1.setIntDays(BkNum3);
                String BkAmt1 = JDomUtils.getChildText((Element)detail, (String)"BkAmt1");
                detail1.setRecInt(BkAmt1);
                noteInfoDetails.add(detail1);
            }
        }
        EBBankNoteInfoResponse response1 = new EBBankNoteInfoResponse();
        infoDetail.setDetails(noteInfoDetails);
        response1.setBody(infoDetail);
        return response1;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "6WH050";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0\u8bd5\u7b97", (String)"NoteInfoImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteInfoRequest noteInfoRequest) {
        return !"0".equals(noteInfoRequest.getBody().getIsNewECDS());
    }

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 10;
    }
}

