/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryRegisterNotePayableImpl
extends AbstractQueryNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRegisterNotePayableImpl.class);
    public static final int PAGE_SIZE = 200;

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "b2e0113";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u51fa\u7968\u67e5\u8be2", (String)"QueryRegisterNotePayableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            this.logger.info("\u603b\u6570\u4e3a" + pageTotalNumStr);
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(pageTag) - 1;
                this.logger.info("\u5f53\u524d\u9875\u6570\uff1a" + page);
                boolean bl = flag = page * 200 >= pageTotalNum;
                if (pageTotalNum < 200) {
                    flag = true;
                }
                this.logger.info("\u5f53\u524d\u662f\u5426\u6700\u540e\u4e00\u9875\uff1a" + flag);
            }
        } else {
            flag = true;
        }
        this.logger.info("\u8fdb\u5165\u64a4\u9500\u5206\u9875" + flag);
        return flag;
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        return this.packQueryPay(request.getNotePayableInfoList(), pageTag);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        Element txbody;
        Element detaillist;
        List list;
        List notePayableInfos = request.getNotePayableInfoList();
        Element header = CCB_DC_Parser.parseString2Root(responseStr);
        BankResponse response = CCB_DC_Parser.parseResponse(header);
        if (!response.getResponseCode().equals("000000") && !response.getResponseCode().equals("YBLECDA66261")) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        if ((list = (detaillist = (txbody = header.getChild("TX_INFO")).getChild("DETAILLIST")).getChildren("DETAILINFO")).size() == 0) {
            this.logger.info("\u8fd4\u56de\u7684\u8282\u70b9\u957f\u5ea6\u4e3a0");
        }
        for (int i = 0; i < notePayableInfos.size(); ++i) {
            NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(i);
            for (Element element : list) {
                String BkListNo1 = element.getChildTextTrim("BkListNo1");
                String BkListNo5 = element.getChildTextTrim("BkListNo5");
                if (info.getBankBatchCount() > 30) {
                    BkListNo5 = element.getChildTextTrim("BkListNo2");
                }
                String status = element.getChildTextTrim("BkFlag2");
                String BkDetail3 = element.getChildTextTrim("BkDetail3");
                String BkFlag1 = element.getChildTextTrim("BkFlag1");
                if (!info.getBillNo().equals(BkListNo5) && !info.getBillNo().equals(BkListNo1)) continue;
                this.logger.info("\u5339\u914d\u5230\u7968\u53f7" + info.getBillNo());
                if ("020006".equals(BkFlag1)) {
                    info.setBillNo(BkListNo1);
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u6210\u529f", (String)"QueryRegisterNotePayableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                    info.setNoteStatus("020006");
                    continue;
                }
                if ("020001".equals(BkFlag1)) {
                    info.setBillNo(BkListNo1);
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u6210\u529f", (String)"QueryRegisterNotePayableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                    info.setNoteStatus("020001");
                    continue;
                }
                if (status.equals("22") || status.equals("03") || status.equals("05") || status.equals("09") || status.equals("11") || status.equals("14") || status.equals("23")) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e94\u7b54\u7ed3\u679c\u67e5\u8be2\u5931\u8d25\u3002", (String)"QueryRegisterNotePayableImpl_2", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                    continue;
                }
                if (status.equals("02")) {
                    info.setNoteStatus(BkFlag1);
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"QueryRegisterNotePayableImpl_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGNotePayableUtils.setPaymentState((NotePayableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5", (String)"QueryRegisterNotePayableImpl_4", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            }
        }
        return notePayableInfos;
    }

    public int getBatchSize() {
        return 200;
    }

    public String packQueryPay(List<NotePayableInfo> notePayableInfos, String pagTap) {
        NotePayableInfo info = notePayableInfos.get(0);
        this.logger.info("\u5f53\u524d\u67e5\u8be2\u6570\u91cf\u4e3a\uff1a" + notePayableInfos.size());
        this.logger.info("\u6279\u6b21\u6570\u91cf\u4e3a\uff1a" + info.getTotalCount());
        if (info.getTotalCount() > 30) {
            Element header = CCB_DC_Packer.createTransactionHeader("6WH048", info.getBankBatchSeqId());
            Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
            this.logger.info("\u6279\u91cf\u7ed3\u679c\u67e5\u8be2\u6279\u6b21\u53f7\uff1a" + info.getObssid());
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getObssid());
            JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pagTap);
            JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
            return NoteCommonPacker.root2StringSafeMod(header);
        }
        Element header = CCB_DC_Packer.createTransactionHeader("6WH026", info.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
        JDomUtils.addChild((Element)txBody, (String)"BKTYPE", (String)info.getDraftType());
        String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
        JDomUtils.addChild((Element)txBody, (String)"Bk10Date1", (String)signDate4Test);
        JDomUtils.addChild((Element)txBody, (String)"Bk10Date2", (String)signDate4Test);
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date3", (String)notePayableInfos.get(0).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"Bk8Date4", (String)notePayableInfos.get(0).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkAmt1", (String)"");
        JDomUtils.addChild((Element)txBody, (String)"BkAmt2", (String)"");
        if (info.getBillNo().length() == 30 && info.getBankBatchCount() == 1) {
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getBillNo());
        }
        JDomUtils.addChild((Element)txBody, (String)"BkType2", (String)"0000");
        JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pagTap);
        JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }
}

