/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.pledge;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.QueryNoteStatusPacker;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.pledge.PledgeNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryPledgeNoteReceivableImpl
extends AbstractQueryNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(PledgeNoteReceivableImpl.class);
    public static final int PAGE_SIZE = 200;

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        if (info.getBankBatchCount() > 1) {
            Element header = CCB_DC_Packer.createTransactionHeader("6WH048", info.getBankBatchSeqId());
            Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getObssid());
            JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTag);
            JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
            return NoteCommonPacker.root2StringSafeMod(header);
        }
        return QueryNoteStatusPacker.packQueryPay(receivableInfos, "0006");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo noteReceivableinfo = (NoteReceivableInfo)receivableInfos.get(0);
        Element root = CCB_DC_Parser.parseString2Root(responseStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!response.getResponseCode().equals("000000") && !response.getResponseCode().equals("YBLECDA66261")) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element txBody = root.getChild("TX_INFO");
            Element detaillist = txBody.getChild("DETAILLIST");
            List lists = detaillist.getChildren("DETAILINFO");
            for (NoteReceivableInfo info : receivableInfos) {
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                    if (!BkListNo1.equals(info.getBillNo())) continue;
                    String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                    String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag1");
                    String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                    if (BkFlag2.equals("00") || BkFlag2.equals("06") || BkFlag1.equals("180006")) {
                        info.setNoteStatus(BkFlag1);
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"QueryPledgeNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                        continue;
                    }
                    if (BkFlag2.equals("02")) {
                        info.setNoteStatus(BkFlag1);
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u94f6\u884c\u5df2\u63a5\u6536\u3002", (String)"QueryPledgeNoteReceivableImpl_5", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), BkSumry));
                        continue;
                    }
                    if (BkFlag2.equals("04")) {
                        info.setNoteStatus(BkFlag1);
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u5f85\u7b7e\u6536", (String)"QueryPledgeNoteReceivableImpl_6", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), BkSumry));
                        continue;
                    }
                    if (BkFlag2.equals("22") || BkFlag2.equals("03") || BkFlag2.equals("05") || BkFlag2.equals("09") || BkFlag2.equals("11") || BkFlag2.equals("14") || BkFlag2.equals("23")) {
                        info.setNoteStatus(BkFlag1);
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                        continue;
                    }
                    if (BkFlag2.equals("07")) {
                        info.setNoteStatus(BkFlag1);
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u65b9\u9a73\u56de", (String)"QueryPledgeNoteReceivableImpl_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                        continue;
                    }
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                }
            }
        }
        return receivableInfos;
    }

    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d28\u62bc\u7ed3\u679c\u67e5\u8be2", (String)"QueryPledgeNoteReceivableImpl_4", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        if (((NoteReceivableInfo)noteReceivableInfos.get(0)).getBankBatchCount() > 1) {
            return super.doBizWithPage(request);
        }
        return super.doBizNoPage(request);
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            this.logger.info("\u603b\u6570\u4e3a" + pageTotalNumStr);
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(pageTag) - 1;
                boolean bl = flag = page * 200 >= pageTotalNum;
                if (pageTotalNum < 200) {
                    flag = true;
                }
            }
        } else {
            flag = true;
        }
        return flag;
    }
}

