/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.repledge;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonParser;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.repledge.QueryRepledgeNoteReceivableImpl;
import kd.ebg.note.banks.ccb.dc.services.utils.BoshAcntAreaCodeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class RepledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryRepledgeNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        for (NoteReceivableInfo info : receivableInfos) {
            info.setPayeeAccNo(BoshAcntAreaCodeUtil.getAccNoWithoutAreaCode(info.getPayeeAccNo(), info.getPayeeBankName()));
        }
        NoteReceivableInfo receivableInfo = (NoteReceivableInfo)receivableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH010", receivableInfo.getBankBatchSeqId());
        Element txBody = NoteCommonPacker.createTransactionBody(header, "", receivableInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)receivableInfo.getBillNo());
        JDomUtils.addChild((Element)txBody, (String)"ecdsType", (String)receivableInfo.getDraftType());
        JDomUtils.addChild((Element)txBody, (String)"Bk60Name1", (String)receivableInfo.getPayeeAccName());
        JDomUtils.addChild((Element)txBody, (String)"BkAcctNo1", (String)receivableInfo.getPayeeAccNo());
        JDomUtils.addChild((Element)txBody, (String)"BkBrchNo1", (String)receivableInfo.getPayeeBankCnaps());
        JDomUtils.addChild((Element)txBody, (String)"BkDetail1");
        JDomUtils.addChild((Element)txBody, (String)"BkEcdBatchNo", (String)receivableInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)txBody, (String)"BkHvpBrchNo", (String)receivableInfo.getPayeeBankCnaps());
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        NoteCommonParser.parsePay(request.getNoteReceivableInfos(), responseStr);
        return request.getNoteReceivableInfos();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u89e3\u8d28\u62bc", (String)"RepledgeNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

