/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.PackerUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.codeless.PackerUtil.PackerCommon;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.note.business.ObjectToMap.BussinessToMap;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoRequest;
import kd.ebg.note.common.entity.biz.notedetail.Detail;

public class PackerUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PackerUtil.class);
    private static final String SPLIT = " ";

    public static String packerPayable(BankNotePayableRequest request, Map<String, String> map, String structId, String dateStr) {
        List<Map<String, String>> dataList = BussinessToMap.getMapListPayable(request.getNotePayableInfoList(), dateStr);
        return PackerCommon.packerCommon(dataList, map, (String)structId, (String)"notePayable");
    }

    public static String packerReceivable(BankNoteReceivableRequest request, Map<String, String> map, String structId, String dateStr) {
        List<Map<String, String>> dataList = BussinessToMap.getMapListReceivable(request.getNoteReceivableInfos(), dateStr);
        return PackerCommon.packerCommon(dataList, map, (String)structId, (String)"noteReceivable");
    }

    public static String packerDetail(BankNoteDetailRequest request, Map<String, String> map, String structId, String dateStr) {
        Map<String, String> sourceDate = BussinessToMap.getMapNoteDetail(request.getBody(), dateStr);
        sourceDate.put("accno", request.getAcnt().getAccNo());
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(1);
        dataList.add(sourceDate);
        return PackerCommon.packerCommon(dataList, map, (String)structId, (String)"queryNoteDetail");
    }

    public static String packerInfo(BankNoteInfoRequest request, Map<String, String> map, String structId, String dateStr) {
        List<Map<String, String>> sourceDate = BussinessToMap.getMapNoteInfo(request.getBody(), dateStr);
        return PackerCommon.packerCommon(sourceDate, map, (String)structId, (String)"queryNoteInfo");
    }

    public static String packerInfo(Detail detail, Map<String, String> map, String structId, String dateStr, String accno) {
        Map<String, String> sourceDate = BussinessToMap.getMapSide(detail, dateStr);
        sourceDate.put("accno", accno);
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(1);
        dataList.add(sourceDate);
        return PackerCommon.packerCommon(dataList, map, (String)structId, (String)"queryNoteSide");
    }

    public static String packer4Detail(Detail detail, Map<String, String> map, String structId, String dateStr, String accno, String bizType) {
        Map<String, String> sourceDate = BussinessToMap.getMapSide(detail, dateStr);
        sourceDate.put("accno", accno);
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(1);
        dataList.add(sourceDate);
        return PackerCommon.packerCommon(dataList, map, (String)structId, (String)bizType);
    }
}

