/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteDetail;

import java.net.MalformedURLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.noteDetail.atomic.INoteDetail;
import kd.ebg.note.business.noteDetail.atomic.INoteDetailPretreat;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.business.util.AccessUtils;
import kd.ebg.note.business.util.NoteRngNoUtils;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.DetailResponseBody;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailResponse;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import org.slf4j.MDC;

public class NoteDetailMethod
implements EBServiceMethod<NoteDetailRequest, NoteDetailResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(NoteDetailMethod.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NoteDetailResponse executeClientRequest(NoteDetailRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        String customId = context.getCustomID();
        BankAcnt bankAcnt = context.getBankAcnt();
        if ("hold".equals(context.getSubBizName())) {
            String noteDeatilKey = customId + bankAcnt.getAccNo() + "noteDetail" + context.getSubBizName() + request.getBody().getDraftType() + request.getBody().getPageNum() + request.getBody().getIsNewECDS();
            String cache_token = CosmicCache.get((String)noteDeatilKey);
            if (StringUtils.isNotEmpty((String)cache_token)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u540c\u4e00\u8d26\u53f7\u5341\u5206\u949f\u5185\u53ea\u80fd\u67e5\u8be2\u4e00\u6b21\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NoteDetailMethod_0", (String)"ebg-note-business", (Object[])new Object[0]));
            }
            CosmicCache.putIfAbsentWithExpire((String)noteDeatilKey, (String)noteDeatilKey, (int)600, (TimeUnit)TimeUnit.SECONDS);
        }
        EBContext.initParameter();
        FEPAccess access = null;
        INoteDetail detail = null;
        String bankVersionId = EBContext.getContext().getBankVersionID();
        INoteDetailPretreat pretreat = (INoteDetailPretreat)BankBundleManager.getInstance().getImpl(bankVersionId, INoteDetailPretreat.class, (Object)request);
        if (pretreat != null) {
            pretreat.appendData(request);
            String implClassName = request.getImplClassName();
            detail = (INoteDetail)BankBundleManager.getInstance().getImplByClassName(bankVersionId, INoteDetail.class, implClassName);
        } else {
            detail = (INoteDetail)BankBundleManager.getInstance().getImpl(EBContext.getContext().getBankAcnt().getBankVersionId(), INoteDetail.class, (Object)request);
        }
        if (detail == null) {
            log.error("\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5b9e\u73b0\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\u5b9e\u73b0\u3002", (String)"NoteDetailMethod_2", (String)"ebg-note-business", (Object[])new Object[0]));
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
        access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
        EBBankDetailResponse response = detail.detail(this.buildRequest(context.getAcnt(), request));
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        FEPAccessUtil.release((FEPAccess)access);
        try {
            if (!"hold".equals(context.getSubBizName())) return this.buildResponse(response);
            BankLoginConfigKey key = new BankLoginConfigKey();
            key.setBankLoginId(context.getBankLoginID());
            key.setBankVersionId(context.getBankVersionID());
            key.setCustomID(EBContext.getContext().getCustomID());
            key.setBankConfigId("note_leaseNum");
            String leaseNumStr = BankLoginConfigService.getInstance().getBankLoginConfigValue(key);
            if (StringUtils.isEmpty((String)leaseNumStr) || "0".equals(leaseNumStr)) {
                leaseNumStr = "1";
            }
            response.setConcurrent(leaseNumStr);
            return this.buildResponse(response);
        }
        catch (Throwable t) {
            log.error("Concurren error", t);
            return this.buildResponse(response);
        }
        catch (EBServiceException e) {
            try {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                log.info("EBServiceException:" + e.getMessage());
                log.error(EBExceiptionUtil.stackTraceString((StackTraceElement[])e.getStackTrace()));
                throw e;
                catch (Throwable e2) {
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    log.error("Throwable:", e2);
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5f02\u5e38", (String)"NoteDetailMethod_3", (String)"ebg-note-business", (Object[])new Object[0]), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                FEPAccessUtil.release(access);
                throw throwable;
            }
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "queryNoteDetail";
    }

    private BankNoteDetailRequest buildRequest(BankAcnt acnt, NoteDetailRequest detailRequest) {
        BankNoteDetailRequest request = new BankNoteDetailRequest();
        BankHeader header = new BankHeader();
        BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
        request.setHeader(header);
        request.setBody(body);
        header.setAcnt(acnt);
        header.setBizType(detailRequest.getHeader().getBizType());
        header.setSubBizType(detailRequest.getHeader().getSubBizType());
        header.setClientName(detailRequest.getHeader().getClientName());
        header.setClientVersion(detailRequest.getHeader().getClientVersion());
        header.setExtData(detailRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(detailRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(detailRequest.getHeader().getCustomId());
        request.getBody().setDraftType(detailRequest.getBody().getDraftType());
        request.getBody().setTranType(detailRequest.getBody().getTranType());
        request.getBody().setNoteNo(detailRequest.getBody().getNoteNo());
        request.getBody().setPageNum(detailRequest.getBody().getPageNum());
        request.getBody().setGrdBag(detailRequest.getBody().getGrdBag());
        request.getBody().setIsNewECDS(detailRequest.getBody().getIsNewECDS());
        String split4SubRange = BankBundleManager.getInstance().getBankSplit(EBContext.getContext().getBankVersionID());
        String subRange = detailRequest.getBody().getSubRange();
        if (StringUtils.isNotEmpty((String)subRange) && !"0".equals(subRange)) {
            String[] split = StringUtils.split((String)subRange, (String)",");
            request.getBody().setStartNo(split[0]);
            request.getBody().setEndNo(split[1]);
            request.getBody().setSubRange(subRange.replaceAll(",", split4SubRange));
        } else if ("0".equals(subRange)) {
            request.getBody().setStartNo("0");
            request.getBody().setEndNo("0");
            request.getBody().setSubRange("0");
        }
        if (!StringUtils.isEmpty((String)detailRequest.getBody().getStartDueDate())) {
            request.getBody().setStartDueDate(LocalDate.parse(detailRequest.getBody().getStartDueDate(), DateTimeFormatter.ofPattern("yyyyMMdd").withLocale(Locale.CHINA)));
        }
        if (!StringUtils.isEmpty((String)detailRequest.getBody().getEndDueDate())) {
            request.getBody().setEndDueDate(LocalDate.parse(detailRequest.getBody().getEndDueDate(), DateTimeFormatter.ofPattern("yyyyMMdd").withLocale(Locale.CHINA)));
        }
        if (!StringUtils.isEmpty((String)detailRequest.getBody().getStartIssueDate())) {
            request.getBody().setStartIssueDate(LocalDate.parse(detailRequest.getBody().getStartIssueDate(), DateTimeFormatter.ofPattern("yyyyMMdd").withLocale(Locale.CHINA)));
        }
        if (!StringUtils.isEmpty((String)detailRequest.getBody().getEndIssueDate())) {
            request.getBody().setEndIssueDate(LocalDate.parse(detailRequest.getBody().getEndIssueDate(), DateTimeFormatter.ofPattern("yyyyMMdd").withLocale(Locale.CHINA)));
        }
        return request;
    }

    private NoteDetailResponse buildResponse(EBBankDetailResponse ebBankDetailResponse) {
        NoteDetailResponse detailResponse = new NoteDetailResponse();
        DetailResponseBody detailResponseBody = new DetailResponseBody();
        detailResponse.setBody(detailResponseBody);
        List<Detail> list = ebBankDetailResponse.getDetails();
        for (Detail detail : list) {
            detail.setCurrency("CNY");
            String subRange = detail.getSubRange();
            if (StringUtils.isNotEmpty((String)subRange) && !subRange.equals("0") && !subRange.equals("000000000000,000000000000")) {
                String[] split;
                subRange = subRange.replaceAll("[^\\d]", ",");
                detail.setSubRange(subRange);
                if (!subRange.contains(",") || (split = subRange.split(",")).length != 2) continue;
                String startNo = NoteRngNoUtils.getForMatBillNoRng(split[0]);
                String endNo = NoteRngNoUtils.getForMatBillNoRng(split[1]);
                detail.setSubRange(startNo + ',' + endNo);
                detail.setStartNo(startNo);
                detail.setEndNo(endNo);
                continue;
            }
            if ("0".equals(detail.getGrdBag())) {
                detail.setSubRange("0");
                detail.setStartNo("0");
                detail.setEndNo("0");
                continue;
            }
            if (!StringUtils.isNotEmpty((String)detail.getStartNo()) || !StringUtils.isNotEmpty((String)detail.getEndNo())) continue;
            String startNo = NoteRngNoUtils.getForMatBillNoRng(detail.getStartNo());
            String endNo = NoteRngNoUtils.getForMatBillNoRng(detail.getEndNo());
            detail.setSubRange(startNo + ',' + endNo);
        }
        detailResponseBody.setBatchSeqId(MDC.get((String)"logger_batch_no"));
        detailResponseBody.setDetails(list);
        detailResponseBody.setTotalCount(ebBankDetailResponse.getDetails().size());
        detailResponseBody.setKeepFlag(ebBankDetailResponse.getKeepFlag());
        detailResponseBody.setTotalPage(ebBankDetailResponse.getTotalPage());
        detailResponseBody.setConcurrent(ebBankDetailResponse.getConcurrent());
        return detailResponse;
    }
}

