/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.notePayable;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.business.notePayable.util.NotePayableConvert;
import kd.ebg.note.business.notePayable.util.NotePayableUtil;
import kd.ebg.note.business.util.AccessUtils;
import kd.ebg.note.common.entity.biz.notepayable.NotePayableRequest;
import kd.ebg.note.common.entity.biz.notepayable.NotePayableResponse;
import kd.ebg.note.common.framework.services.NotePayableInfoService;
import kd.ebg.note.common.model.NotePayableInfo;
import org.slf4j.MDC;

public class NotePayableMethod
implements EBServiceMethod<NotePayableRequest, NotePayableResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(NotePayableMethod.class);

    public NotePayableResponse executeClientRequest(NotePayableRequest request, EBContext context) {
        AccessUtils.checkQueryAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        try {
            this.logger.info("\u6570\u636e\u6821\u9a8c\u5f00\u59cb");
            this.checkStructure(request);
            String batchSeqID = request.getBody().getBatchSeqId();
            this.logger.info("\u8bbf\u95ee\u6570\u636e\u5e93");
            this.checkBatchSeqIDUnique(batchSeqID);
            this.logger.info("\u6570\u636e\u6821\u9a8c\u5b8c\u6210");
        }
        catch (IllegalArgumentException e) {
            this.logger.error(e.getMessage() + e.getLocalizedMessage());
            throw EBExceiptionUtil.preCheckException((Throwable)e);
        }
        List<NotePayableInfo> notePayableInfos = NotePayableConvert.convertPay(request);
        this.logger.info("\u9884\u5904\u7406\u6570\u636e");
        NotePayableUtil.preTreatment(notePayableInfos);
        Set<List<NotePayableInfo>> set = NotePayableConvert.packagePay(notePayableInfos);
        set = NotePayableUtil.reloadData(set);
        this.logger.info("\u63d2\u5165\u6570\u636e");
        NotePayableUtil.insertPay(notePayableInfos);
        this.logger.info("\u63d2\u5165\u6570\u636e\u7ed3\u675f");
        NotePayableUtil.async(set, (EBRequest)request, context.getAcnt());
        return NotePayableConvert.convertToResponse(notePayableInfos, request);
    }

    private void checkStructure(NotePayableRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NotePayableMethod_0", (String)"ebg-note-business", (Object[])new Object[0]));
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NotePayableMethod_1", (String)"ebg-note-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42 body \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NotePayableMethod_2", (String)"ebg-note-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u5e94\u4ed8\u7968\u636e\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NotePayableMethod_3", (String)"ebg-note-business", (Object[])new Object[0]));
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "notePayable";
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NotePayableMethod_4", (String)"ebg-note-business", (Object[])new Object[0]));
        boolean flag = NotePayableInfoService.getInstance().batchSeqIDExist(batchSeqID);
        Preconditions.checkState((!flag ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"batchSeqID \u5df2\u7ecf\u5b58\u5728\u3002", (String)"NotePayableMethod_5", (String)"ebg-note-business", (Object[])new Object[0]));
    }
}

