/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteReceivable.util;

import java.time.LocalDateTime;
import java.util.List;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class EBGNoteReceivableUtils {
    public static void setPaymentState(List<NoteReceivableInfo> paymentInfos, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        for (NoteReceivableInfo info : paymentInfos) {
            EBGNoteReceivableUtils.setPaymentState(info, state, errorMsg, bankStatus, bankMsg);
            EBGNoteReceivableUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentState(NoteReceivableInfo paymentInfo, PaymentState state, String errorMsg, String bankStatus, String bankMsg) {
        paymentInfo.setStatus(Integer.valueOf(state.getId()));
        paymentInfo.setStatusName(state.getEnName());
        paymentInfo.setStatusMsg(state.getCnName());
        if (StrUtil.isNotBlank((CharSequence)errorMsg)) {
            if (errorMsg.length() > 250) {
                paymentInfo.setErrorMsg(errorMsg.substring(0, 250) + "...");
            } else {
                paymentInfo.setErrorMsg(errorMsg);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            paymentInfo.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg) && StringUtils.isNotEmpty((String)bankMsg)) {
            if (bankMsg.length() > 250) {
                paymentInfo.setBankMsg(bankMsg.substring(0, 250) + "...");
            } else {
                paymentInfo.setBankMsg(bankMsg);
            }
        }
    }

    public static void setPaymentUpdateTimeAndStatus(NoteReceivableInfo paymentInfos, LocalDateTime updateTime) {
        paymentInfos.setUpdateTime(updateTime);
    }

    public static void setPaymentUpdateTimeAndStatus(List<NoteReceivableInfo> paymentInfos, LocalDateTime updateTime) {
        for (NoteReceivableInfo info : paymentInfos) {
            info.setUpdateTime(updateTime);
            PaymentState state = PaymentState.getEnumById((int)info.getStatus());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
        }
    }

    public static void setPaymentState(List<NoteReceivableInfo> paymentInfos, PaymentState state, String bankStatus, String bankMsg) {
        for (NoteReceivableInfo info : paymentInfos) {
            EBGNoteReceivableUtils.setPaymentState(info, state, bankStatus, bankMsg);
            EBGNoteReceivableUtils.setPaymentUpdateTimeAndStatus(info, LocalDateTime.now());
        }
    }

    public static void setPaymentState(NoteReceivableInfo paymentInfo, PaymentState state, String bankStatus, String bankMsg) {
        paymentInfo.setStatus(Integer.valueOf(state.getId()));
        paymentInfo.setStatusName(state.getEnName());
        paymentInfo.setStatusMsg(state.getCnName());
        if (StrUtil.isNotBlank((CharSequence)bankStatus)) {
            paymentInfo.setBankStatus(bankStatus);
        }
        if (StrUtil.isNotBlank((CharSequence)bankMsg) && StringUtils.isNotEmpty((String)bankMsg)) {
            if (bankMsg.length() > 250) {
                paymentInfo.setBankMsg(bankMsg.substring(0, 250) + "...");
            } else {
                paymentInfo.setBankMsg(bankMsg);
            }
        }
    }

    public static void setNoteBatchNo(List<NoteReceivableInfo> infos, String batchNo) {
        for (NoteReceivableInfo info : infos) {
            info.setObssid(batchNo);
        }
    }
}

