/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteReceivable.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.INoteReceivable;
import kd.ebg.note.business.util.CheckLengthUtil;
import kd.ebg.note.business.util.CheckUtil;
import kd.ebg.note.business.util.NoteRngNoUtils;
import kd.ebg.note.common.entity.biz.notereceivable.NoteReceivableBody;
import kd.ebg.note.common.entity.biz.notereceivable.NoteReceivableDetail;
import kd.ebg.note.common.entity.biz.notereceivable.NoteReceivableRequest;
import kd.ebg.note.common.entity.biz.notereceivable.NoteReceivableResponse;
import kd.ebg.note.common.entity.biz.querynotereceivable.QueryNoteReceivableRequest;
import kd.ebg.note.common.entity.biz.querynotereceivable.QueryNoteReceivableResponse;
import kd.ebg.note.common.entity.biz.status.EbStatus;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.frame.BankBundleManager;
import kd.ebg.note.common.framework.utils.CurrencyUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class NoteReceivableConvert {
    public static QueryNoteReceivableResponse convertToResponse(List<NoteReceivableInfo> noteReceivableInfos, QueryNoteReceivableRequest queryNoteReceivableRequest) {
        QueryNoteReceivableResponse response = new QueryNoteReceivableResponse();
        response.setHeader(queryNoteReceivableRequest.getHeader());
        NoteReceivableBody body = NoteReceivableConvert.convert2Body(noteReceivableInfos);
        body.setBatchSeqId(queryNoteReceivableRequest.getBody().getBatchSeqId());
        response.setBody(body);
        return response;
    }

    public static NoteReceivableResponse convertToResponse(List<NoteReceivableInfo> noteReceivableInfos, NoteReceivableRequest payRequest) {
        NoteReceivableResponse response = new NoteReceivableResponse();
        response.setHeader(payRequest.getHeader());
        NoteReceivableBody body = NoteReceivableConvert.convert2Body(noteReceivableInfos);
        body.setBatchSeqId(payRequest.getBody().getBatchSeqId());
        body.setTotalAmount(payRequest.getBody().getTotalAmount());
        body.setTotalCount(payRequest.getBody().getTotalCount());
        response.setBody(body);
        return response;
    }

    public static NoteReceivableBody convert2Body(List<NoteReceivableInfo> noteReceivableInfos) {
        NoteReceivableBody body = new NoteReceivableBody();
        ArrayList<NoteReceivableDetail> details = new ArrayList<NoteReceivableDetail>(noteReceivableInfos.size());
        for (NoteReceivableInfo info : noteReceivableInfos) {
            NoteReceivableDetail detail = new NoteReceivableDetail();
            FieldUtils.fieldsCopy((Object)info, (Object)detail);
            details.add(detail);
            String subRange = detail.getSubRange();
            if (StringUtils.isNotEmpty((String)subRange) && !subRange.equals("0") && !subRange.equals("000000000000,000000000000")) {
                subRange = subRange.replaceAll("[^\\d]", ",");
                detail.setSubRange(subRange);
                if (StringUtils.isNotEmpty((String)detail.getStartNo()) && StringUtils.isNotEmpty((String)detail.getEndNo())) {
                    String startNo = detail.getStartNo();
                    String endNo = detail.getEndNo();
                    BigDecimal start = new BigDecimal(startNo);
                    BigDecimal end = new BigDecimal(endNo);
                    String[] split = subRange.split(",");
                    if (split.length == 2) {
                        BigDecimal secondRange;
                        BigDecimal sub1 = new BigDecimal(split[0]);
                        BigDecimal sub2 = new BigDecimal(split[1]);
                        BigDecimal firstRange = end.subtract(start);
                        int result = firstRange.compareTo(secondRange = sub2.subtract(sub1));
                        if (result < 0) {
                            detail.setSubRange(startNo + ',' + endNo);
                        } else if (result > 0) {
                            detail.setStartNo(split[0]);
                            detail.setEndNo(split[1]);
                        }
                    }
                }
            } else if ("0".equals(detail.getGrdBag())) {
                detail.setStartNo("0");
                detail.setEndNo("0");
                detail.setSubRange("0");
            }
            detail.setOppAmount(info.getAmount().toString());
            NoteReceivableConvert.formateNo(detail);
            NoteReceivableConvert.modifyRange(detail);
            detail.setBankMsg(info.bankMsgDetails());
            detail.setEbSeqID(info.getId() + "");
            detail.setRspSerialNo(info.getRspserialno());
            if (info.getAmount() != null) {
                detail.setOppAmount(info.getAmount().toString());
            }
            detail.setEbStatus(EbStatus.convertBankState2EBG((PaymentState)PaymentState.getEnumById((int)info.getStatus())).getName());
            if (StringUtils.isNotEmpty((String)info.getErrorMsg())) {
                detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%1$s\uff0c\u94f6\u4f01\u5f02\u5e38\uff1a%2$s\u3002", (String)"NoteReceivableConvert_14", (String)"ebg-note-business", (Object[])new Object[0]), info.getStatusMsg(), info.getErrorMsg()));
                continue;
            }
            detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u4e91\uff1a%s\u3002", (String)"NoteReceivableConvert_15", (String)"ebg-note-business", (Object[])new Object[0]), info.getStatusMsg()));
        }
        body.setDetails(details);
        body.setTotalCount(noteReceivableInfos.size());
        return body;
    }

    public static void modifyRange(NoteReceivableDetail info) {
        if ("0".equals(info.getGrdBag())) {
            return;
        }
        if (StringUtils.isEmpty((String)info.getOrgStartNo()) || StringUtils.isEmpty((String)info.getOrgEndNo())) {
            return;
        }
        if (StringUtils.isEmpty((String)info.getIsRefuse())) {
            return;
        }
        if ("0".equals(info.getIsRefuse())) {
            info.setStartNo(info.getOrgStartNo());
            info.setEndNo(info.getOrgEndNo());
            info.setSubRange(info.getOrgStartNo() + ',' + info.getOrgEndNo());
        } else if ("1".equals(info.getIsRefuse()) && StringUtils.isNotEmpty((String)info.getOppAmount())) {
            info.setStartNo(info.getOrgStartNo());
            BigDecimal amount = new BigDecimal(info.getOppAmount()).multiply(new BigDecimal("100"));
            Long endNoLong = Long.parseLong(info.getOrgStartNo()) + amount.longValue() - 1L;
            String endNo = NoteRngNoUtils.getResponseNo(String.valueOf(endNoLong));
            info.setEndNo(endNo);
            info.setSubRange(info.getOrgStartNo() + ',' + endNo);
        }
    }

    public static List<NoteReceivableInfo> convertPay(NoteReceivableRequest request) {
        NoteReceivableBody body = request.getBody();
        String bizType = request.getHeader().getBizType();
        String subBizType = request.getHeader().getSubBizType();
        String currency = request.getHeader().getCurrency();
        int totalCount = body.getTotalCount();
        BigDecimal totalAmount = CheckUtil.checkBigDecimal(body.getTotalAmount(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u603b\u91d1\u989d\u4e3a\uff1a\u8bf7\u6c42\u91cc\u7684\u91d1\u989d\u3002", (String)"NoteReceivableConvert_2", (String)"ebg-note-business", (Object[])new Object[0]));
        String batchSeqID = body.getBatchSeqId();
        List payDetails = body.getDetails();
        EBContext context = EBContext.getContext();
        BankAcnt bankAcnt = context.getBankAcnt();
        long requestTimeStamp = request.getHeader().getRequestTime();
        LocalDateTime requestTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(requestTimeStamp), ZoneId.systemDefault());
        Preconditions.checkArgument((totalCount == payDetails.size() ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u603b\u6570(%1$s)\u4e0e\u8be5\u6279\u6b21\u6307\u793a\u7684\u603b\u7b14\u6570(%2$s)\u4e0d\u7b26\u3002", (String)"NoteReceivableConvert_16", (String)"ebg-note-business", (Object[])new Object[0]), payDetails.size(), totalCount));
        BigDecimal actualTotalAmount = new BigDecimal("0.00");
        HashSet detailSeqIDSet = Sets.newHashSetWithExpectedSize((int)payDetails.size());
        ArrayList<NoteReceivableInfo> paymentInfos = new ArrayList<NoteReceivableInfo>(payDetails.size());
        int bankSerialNo = 1;
        BankAcnt acnt = EBContext.getContext().getBankAcnt();
        String split4SubRange = BankBundleManager.getInstance().getBankSplit(context.getBankVersionID());
        for (NoteReceivableDetail detail : payDetails) {
            CheckLengthUtil.checkLength(detail.getDrawerAccName(), "DrawerAccName", 50);
            CheckLengthUtil.checkLength(acnt.getBankAddress(), "DrawerBankAddress", 50);
            CheckLengthUtil.checkLength(detail.getAcceptorAccName(), "AcceptorAccName", 50);
            CheckLengthUtil.checkLength(detail.getAcceptorBankName(), "AcceptorBankName", 50);
            CheckLengthUtil.checkLength(detail.getAcceptorBankAddr(), "AcceptorBankAddr", 50);
            CheckLengthUtil.checkLength(detail.getPayeeAccName(), "PayeeAccName", 50);
            CheckLengthUtil.checkLength(detail.getPayeeBankAddr(), "PayeeBankAddr", 50);
            CheckLengthUtil.checkLength(detail.getPayeeBankName(), "PayeeBankName", 50);
            NoteReceivableInfo info = new NoteReceivableInfo();
            FieldUtils.fieldsCopy((Object)detail, (Object)info);
            FieldUtils.fieldsCopy((Object)bankAcnt, (Object)info);
            info.setBankVersionID(context.getBankVersionID());
            info.setBankLoginID(context.getBankLoginID());
            paymentInfos.add(info);
            info.setDrawerAccCity(acnt.getCity());
            info.setDrawerAccProvince(acnt.getProvince());
            info.setDrawerAccCountry(acnt.getCountry());
            info.setDrawerAccNo(acnt.getAccNo());
            info.setDrawerBankName(acnt.getBankName());
            info.setDrawerAccName(acnt.getAccName());
            info.setDrawerBankCnaps(acnt.getCnaps());
            info.setRspserialno(detail.getRspSerialNo());
            info.setBankSerialNo(String.valueOf(bankSerialNo++));
            info.setPayeeAccNo(detail.getOppAccNo());
            info.setPayeeAccName(detail.getOppAccName());
            info.setPayeeBankName(detail.getOppBankName());
            info.setPayeeBankCnaps(detail.getOppCnapsCode());
            info.setPayeeCity(detail.getOppCity());
            info.setAcceptorAccNo(detail.getAcceptorAccNo());
            info.setAcceptorAccName(detail.getAcceptorAccName());
            info.setAcceptorBankCnaps(detail.getAcceptorCnapsCode());
            info.setAcceptorBankName(detail.getAcceptorBankName());
            info.setBatchSeqId(batchSeqID);
            info.setBizType(bizType);
            info.setSubBizType(subBizType);
            info.setTotalAmount(totalAmount);
            info.setTotalCount(Integer.valueOf(totalCount));
            info.setOperationCode(detail.getOperationCode());
            Preconditions.checkArgument((boolean)Objects.nonNull(detail.getOppAmount()), (Object)ResManager.loadKDString((String)"\u7968\u636e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteReceivableConvert_6", (String)"ebg-note-business", (Object[])new Object[0]));
            info.setAmount(new BigDecimal(detail.getOppAmount()));
            info.setDisCountRate(detail.getDisCountRate());
            info.setDiscountType(detail.getDiscountType());
            info.setDiscountAccName(detail.getDiscountAccName());
            info.setDiscountAccNo(detail.getDiscountAccNo());
            info.setRequestTime(requestTime);
            info.setRequestSeq(Sequence.genSequence());
            info.setInsertBatchSeq(request.getBody().getBatchSeqId());
            info.setDetailBizNo(detail.getDetailBizNo());
            info.setId(Long.valueOf(Sequence.gen16NumSequence()));
            info.setRegisterAcno(detail.getRegisterAcno());
            info.setRegisterNmae(detail.getRegisterName());
            info.setRegisterBankName(detail.getRegisterBankName());
            info.setExplanation(detail.getDesc());
            if (StringUtils.isNotEmpty((String)detail.getBookingDate())) {
                info.setBookingDate(LocalDate.parse(detail.getBookingDate(), DateTimeFormatter.BASIC_ISO_DATE));
            }
            String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
            Preconditions.checkArgument((boolean)Objects.nonNull(bankCurrency), (Object)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u6807\u51c6\u5e01\u79cd%s\u8f6c\u6362\u4e3a\u94f6\u884c\u5e01\u79cd\uff0c\u8bf7\u7ef4\u62a4\u6b63\u786e\u7684\u5e01\u79cd\u6620\u5c04\u3002", (String)"NoteReceivableConvert_17", (String)"ebg-note-business", (Object[])new Object[0]), bankAcnt.getCurrency()));
            info.setCurrency(bankCurrency);
            info.setCurrency(CurrencyUtils.convert2Bank((String)currency));
            String detailSeqID = detail.getDetailSeqID();
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)detailSeqID), (Object)ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584detailSeqID\u3002", (String)"NoteReceivableConvert_9", (String)"ebg-note-business", (Object[])new Object[0]));
            Preconditions.checkState((!detailSeqIDSet.contains(detailSeqID) ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u5e8f\u53f7\u91cd\u590d\uff1a%s\u3002", (String)"NoteReceivableConvert_18", (String)"ebg-note-business", (Object[])new Object[0]), detailSeqID));
            detailSeqIDSet.add(detailSeqID);
            info.setDetailSeqId(detailSeqID);
            info.setCustomID(request.getHeader().getCustomId());
            info.setAmount(CheckUtil.checkBigDecimal(info.getAmount().toString(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d", (String)"NoteReceivableConvert_11", (String)"ebg-note-business", (Object[])new Object[0])));
            actualTotalAmount = actualTotalAmount.add(info.getAmount());
            info.setBankRefKey(detail.getBankRefKey());
            info.setReserved1(detail.getReserved1());
            info.setReserved2(detail.getReserved2());
            info.setReserved3(detail.getReserved3());
            info.setReserved4(detail.getReserveds());
            if (StringUtils.isEmpty((String)info.getIsNewECDS())) {
                info.setIsNewECDS("1");
            }
            info.setGrdBag(detail.getGrdBag());
            info.setStartNo(detail.getStartNo());
            info.setEndNo(detail.getEndNo());
            info.setOrgStartNo(detail.getStartNo());
            info.setOrgEndNo(detail.getEndNo());
            info.setCirStatus(detail.getCirStatus());
            info.setInterest(detail.getInterest());
            String subRange = detail.getSubRange();
            if (StringUtils.isNotEmpty((String)subRange)) {
                info.setSubRange(subRange.replaceAll(",", split4SubRange));
            }
            info.setIsPayeeSameBank(SameBankUtil.isSameBank(EBContext.getContext().getBankVersionID(), detail.getOppBankName()));
            info.setIsAcceptSameBank(SameBankUtil.isSameBank(EBContext.getContext().getBankVersionID(), detail.getAcceptorBankName()));
            info.setDraftAmount(detail.getDraftAmount());
        }
        if (!actualTotalAmount.equals(totalAmount)) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u63a5\u5165\u65b9\u4f20\u7684\u603b\u91d1\u989d\uff1a%1$s\uff0c\u4e0e\u8ba1\u7b97\u540e\u7684\u603b\u91d1\u989d\u4e0d\u7b26\uff1a%2$s\u3002", (String)"NoteReceivableConvert_19", (String)"ebg-note-business", (Object[])new Object[0]), totalAmount, actualTotalAmount));
        }
        return paymentInfos;
    }

    private static void addBankSeqID(String bankVersionID, List<NoteReceivableInfo> infos) {
        String bankBatchSeqID = "";
        IBankBatchSeqIDCreator bankBatchSeqIDCreator = (IBankBatchSeqIDCreator)BankBundleManager.getInstance().getBatchSeqIdImplOrNull(bankVersionID);
        if (StringUtils.isEmpty((String)bankBatchSeqID)) {
            bankBatchSeqID = Objects.nonNull(bankBatchSeqIDCreator) ? bankBatchSeqIDCreator.getBankBatchSeqID() : Sequence.gen16Sequence();
            EBContext.getContext().setBizSeqID(bankBatchSeqID);
        }
        for (NoteReceivableInfo info : infos) {
            info.setBankBatchSeqId(bankBatchSeqID);
            info.setBankBatchCount(infos.size());
            info.setStatus(Integer.valueOf(PaymentState.PACKAGED.getId()));
            info.setStatusName(PaymentState.PACKAGED.getEnName());
            info.setStatusMsg(PaymentState.PACKAGED.getCnName());
            IBankDetailSeqIDCreator bankDetailSeqIDCreator = (IBankDetailSeqIDCreator)BankBundleManager.getInstance().getDetailSeqIdImplOrNull(bankVersionID);
            String bankDetailSeqID = Objects.nonNull(bankDetailSeqIDCreator) ? bankDetailSeqIDCreator.getBankDetailSeqID() : Sequence.genSequence();
            info.setBankDetailSeqId(bankDetailSeqID);
        }
    }

    public static Set<List<NoteReceivableInfo>> packagePay(List<NoteReceivableInfo> paymentInfos) {
        List infos;
        String bankVersionID = paymentInfos.get(0).getBankVersionID();
        HashSet<List<NoteReceivableInfo>> result = new HashSet<List<NoteReceivableInfo>>();
        HashMap maps = Maps.newHashMap();
        for (NoteReceivableInfo noteReceivableInfo : paymentInfos) {
            String implClassName = noteReceivableInfo.getImplClassName();
            if (maps.containsKey(implClassName)) {
                infos = (List)maps.get(implClassName);
                infos.add(noteReceivableInfo);
                continue;
            }
            infos = Lists.newArrayList((Object[])new NoteReceivableInfo[]{noteReceivableInfo});
            maps.put(implClassName, infos);
        }
        for (Map.Entry entry : maps.entrySet()) {
            String implClass = (String)entry.getKey();
            infos = (List)entry.getValue();
            INoteReceivable pay = (INoteReceivable)BankBundleManager.getInstance().getImplByClassName(bankVersionID, INoteReceivable.class, implClass);
            int batchSize = pay.getBatchSize();
            if (batchSize < 1) {
                batchSize = 1;
            }
            if (infos.size() <= batchSize) {
                NoteReceivableConvert.addBankSeqID(bankVersionID, infos);
                result.add(infos);
                continue;
            }
            for (int startIndex = 0; startIndex < infos.size(); startIndex += batchSize) {
                int endIndex = startIndex + batchSize;
                if (endIndex > infos.size()) {
                    endIndex = infos.size();
                }
                List<NoteReceivableInfo> temp = infos.subList(startIndex, endIndex);
                result.add(temp);
                NoteReceivableConvert.addBankSeqID(bankVersionID, temp);
            }
        }
        return result;
    }

    private static void formateNo(NoteReceivableDetail noteReceivableInfo) {
        noteReceivableInfo.setStartNo(NoteRngNoUtils.getResponseNo(noteReceivableInfo.getStartNo()));
        noteReceivableInfo.setEndNo(NoteRngNoUtils.getResponseNo(noteReceivableInfo.getEndNo()));
        noteReceivableInfo.setSubRange(NoteRngNoUtils.getResponseNoRange(noteReceivableInfo.getSubRange()));
    }
}

