/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.noteUpdateStatus;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.note.business.util.AccessUtils;
import kd.ebg.note.common.entity.biz.noteupdate.NoteStatusUpdateRequest;
import kd.ebg.note.common.entity.biz.noteupdate.NoteStatusUpdateResponse;
import kd.ebg.note.common.entity.biz.status.EbStatus;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.services.NotePayableInfoService;
import kd.ebg.note.common.framework.services.NoteReceivableInfoService;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class NoteStatusUpdateMethod
implements EBServiceMethod<NoteStatusUpdateRequest, NoteStatusUpdateResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(NoteStatusUpdateMethod.class);

    public NoteStatusUpdateResponse executeClientRequest(NoteStatusUpdateRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        this.checkStructure(request);
        List details = request.getBody().getDetails();
        HashSet bathSeqID = new HashSet();
        details.forEach(detail -> {
            Preconditions.checkArgument((detail.getModifyStatus() == 12 || detail.getModifyStatus() == 13 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u679a\u4e3e\u6709\u8bef\u3002", (String)"NoteStatusUpdateMethod_0", (String)"ebg-note-business", (Object[])new Object[0]));
            Preconditions.checkArgument((!StrUtil.isEmpty((String)detail.getUpdateReason()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u4fee\u6539\u7406\u7531\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteStatusUpdateMethod_1", (String)"ebg-note-business", (Object[])new Object[0]));
            bathSeqID.add(detail.getBatchSeqID());
        });
        bathSeqID.forEach(id -> this.checkBatchSeqIDUnique((String)id));
        NotePayableInfoService payableInfoService = NotePayableInfoService.getInstance();
        NoteReceivableInfoService receivableInfoService = NoteReceivableInfoService.getInstance();
        details.forEach(detail -> {
            EbStatus status;
            PaymentState paymentState;
            PaymentState state;
            NotePayableInfo info;
            List payableInfos = payableInfoService.selectByBatchSeqIDAndDetailSeqID(detail.getBatchSeqID(), detail.getDetailSeqID());
            List receivableInfos = receivableInfoService.selectByBatchSeqIDAndDetailSeqID(detail.getBatchSeqID(), detail.getDetailSeqID());
            if (payableInfos.size() == 1) {
                info = (NotePayableInfo)payableInfos.get(0);
                info.setBakStatus(info.getStatus());
                info.setBakStatusMsg(info.getStatusMsg());
                state = PaymentState.getEnumById((int)detail.getModifyStatus());
                info.setStatus(Integer.valueOf(state.getId()));
                info.setStatusName(state.getEnName());
                info.setStatusMsg(state.getCnName());
                try {
                    payableInfoService.save(payableInfos);
                    detail.setEbStatusMsg(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5b8c\u6210", (String)"NoteStatusUpdateMethod_2", (String)"ebg-note-business", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    detail.setUpdateStatus("BANK_FAIL");
                    detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff1a%s\u3002", (String)"NoteStatusUpdateMethod_12", (String)"ebg-note-business", (Object[])new Object[0]), e.getMessage()));
                }
                payableInfos = payableInfoService.selectByBatchSeqIDAndDetailSeqID(detail.getBatchSeqID(), detail.getDetailSeqID());
                info = (NotePayableInfo)payableInfos.get(0);
                paymentState = PaymentState.getEnumById((int)info.getStatus());
                status = EbStatus.convertBankState2EBG((PaymentState)paymentState);
                detail.setEbStatus(status.getName());
                if (paymentState.getId() == detail.getModifyStatus()) {
                    detail.setUpdateStatus("BANK_SUCCESS");
                } else {
                    detail.setUpdateStatus("BANK_FAIL");
                }
            } else {
                detail.setEbStatusMsg(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u591a\u6761\u8bb0\u5f55\u653e\u5f03\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"NoteStatusUpdateMethod_4", (String)"ebg-note-business", (Object[])new Object[0]));
                detail.setUpdateStatus("BANK_FAIL");
            }
            if (receivableInfos.size() == 1) {
                info = (NoteReceivableInfo)receivableInfos.get(0);
                info.setBakStatus(info.getStatus());
                info.setBakStatusMsg(info.getStatusMsg());
                state = PaymentState.getEnumById((int)detail.getModifyStatus());
                info.setStatus(Integer.valueOf(state.getId()));
                info.setStatusName(state.getEnName());
                info.setStatusMsg(state.getCnName());
                try {
                    receivableInfoService.save(receivableInfos);
                    detail.setEbStatusMsg(ResManager.loadKDString((String)"\u4fee\u6539\u72b6\u6001\u5b8c\u6210", (String)"NoteStatusUpdateMethod_2", (String)"ebg-note-business", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    detail.setUpdateStatus("BANK_FAIL");
                    detail.setEbStatusMsg(String.format(ResManager.loadKDString((String)"\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff1a%s\u3002", (String)"NoteStatusUpdateMethod_12", (String)"ebg-note-business", (Object[])new Object[0]), e.getMessage()));
                }
                receivableInfos = receivableInfoService.selectByBatchSeqIDAndDetailSeqID(detail.getBatchSeqID(), detail.getDetailSeqID());
                info = (NoteReceivableInfo)receivableInfos.get(0);
                paymentState = PaymentState.getEnumById((int)info.getStatus());
                status = EbStatus.convertBankState2EBG((PaymentState)paymentState);
                detail.setEbStatus(status.getName());
                if (paymentState.getId() == detail.getModifyStatus()) {
                    detail.setUpdateStatus("BANK_SUCCESS");
                } else {
                    detail.setUpdateStatus("BANK_FAIL");
                }
            } else {
                detail.setEbStatusMsg(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u591a\u6761\u8bb0\u5f55\u653e\u5f03\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"NoteStatusUpdateMethod_4", (String)"ebg-note-business", (Object[])new Object[0]));
                detail.setUpdateStatus("BANK_FAIL");
            }
        });
        NoteStatusUpdateResponse response = new NoteStatusUpdateResponse();
        request.getBody().setDetails(details);
        response.setBody(request.getBody());
        return response;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "noteStatusUpdate";
    }

    private void checkStructure(NoteStatusUpdateRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteStatusUpdateMethod_5", (String)"ebg-note-business", (Object[])new Object[0]));
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteStatusUpdateMethod_6", (String)"ebg-note-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bf7\u6c42 body\u3002", (String)"NoteStatusUpdateMethod_7", (String)"ebg-note-business", (Object[])new Object[0]));
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u4fee\u6539\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"NoteStatusUpdateMethod_8", (String)"ebg-note-business", (Object[])new Object[0]));
                Preconditions.checkArgument((request.getBody().getTotalcount() == request.getBody().getDetails().size() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u66f4\u65b0\u7b14\u6570\u4e0e\u5b9e\u9645\u4e0d\u7b26\u3002", (String)"NoteStatusUpdateMethod_9", (String)"ebg-note-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"NoteStatusUpdateMethod_10", (String)"ebg-note-business", (Object[])new Object[0]));
        Preconditions.checkState((boolean)this.checkBatchId(batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u5e8f\u5217\u53f7\u4e0d\u5b58\u5728\u3002", (String)"NoteStatusUpdateMethod_11", (String)"ebg-note-business", (Object[])new Object[0]));
    }

    private Boolean checkBatchId(String batchSeqID) {
        boolean flag = NotePayableInfoService.getInstance().batchSeqIDExist(batchSeqID);
        if (!flag) {
            flag = NoteReceivableInfoService.getInstance().batchSeqIDExist(batchSeqID);
        }
        return flag;
    }
}

