/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.business.util;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CheckUtil {
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String ILLEAGE_WORD_REGEXT = "[.~!@#$%\\^\\+\\*&\\\\\\/\\?\\|:\\.{}()';=\"\uff5e\uff01\uff20\uff03\uff04\uff05\uff3e\uff06\uff0a\uff08\uff09\uff3f\uff0d\uff0b\uff1d\uff0c\uff0e\uff1f\uff0f]";
    private static final String ALIPAY_ILLEAGE_WORD_REGEXT = "^[-\\+]?[\\d]*$|^[a-zA-Z0-9_.-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
    private static final String ILLEAGE_WORD_REG = "[.~!@#$%\\^\\+\\*&\\\\\\/\\?\\|:\\.{}';=\"\uff5e\uff01\uff20\uff03\uff04\uff05\uff3e\uff06\uff0a\uff3f\uff0d\uff0b\uff1d\uff0c\uff0e\uff1f\uff0f]";
    private static final String NUMBER_REG = "^\\w(\\w*-\\w+)*\\w*$";
    private static final String NUMBER_WORD = "^\\w+$";

    public static BigDecimal checkBigDecimal(String str, String name) {
        int index = (str = CheckUtil.checkStringNotNull(str, name)).indexOf(".");
        if (-1 != index) {
            if (str.length() - 1 - index > 2) {
                throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:%1$s;%2$s\u7684\u503c\u4e3a%3$s,\u8fc7\u4e8e\u7cbe\u786e\uff0c\u800c\u94f6\u4f01\u4e2d\u95f4\u4ef6\u53ea\u652f\u6301\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d\u7684\u91d1\u989d", (String)"CheckUtil_7", (String)"ebg-note-business", (Object[])new Object[0]), str, name, str));
            }
            if (str.length() - 1 - index < 2) {
                throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:%1$s;%2$s\u7684\u503c\u4e3a%3$s,\u7cbe\u786e\u5ea6\u4e0d\u591f\uff0c\u94f6\u4f01\u4e2d\u95f4\u4ef6\u8981\u6c42\u91d1\u989d\u6570\u636e\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d", (String)"CheckUtil_8", (String)"ebg-note-business", (Object[])new Object[0]), str, name, str));
            }
        } else {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u8f93\u5165:%1$s;%2$s\u7684\u503c\u4e3a%3$s,\u7cbe\u786e\u5ea6\u4e0d\u591f\uff0c\u94f6\u4f01\u4e2d\u95f4\u4ef6\u8981\u6c42\u91d1\u989d\u6570\u636e\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d", (String)"CheckUtil_8", (String)"ebg-note-business", (Object[])new Object[0]), str, name, str));
        }
        BigDecimal amount = null;
        try {
            amount = new BigDecimal(str);
            amount = amount.setScale(2, 1);
        }
        catch (Throwable t) {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u9519\u8bef\uff1a%1$s\uff1b%2$s\u7684\u503c\u4e0d\u662f\u6570\u5b57\u3002", (String)"CheckUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), str, name), t);
        }
        return amount;
    }

    private static String checkStringNotNull(String str, String name) {
        if (StringUtils.isEmpty((String)str)) {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5185\u5bb9'%1$s'\u975e\u6cd5\uff01%3$s\u503c\u4e3a\u7a7a\u3002", (String)"CheckUtil_10", (String)"ebg-note-business", (Object[])new Object[0]), str, name));
        }
        return str.trim();
    }

    private static boolean isTestMode() {
        return System.getProperty("testMode", "false").equals("true");
    }

    public static boolean checkNumber(String str) {
        if (CheckUtil.isTestMode()) {
            return true;
        }
        return str.matches(NUMBER_REG);
    }
}

