/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.gdb.dc.services.util.encry;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import kd.ebg.egf.common.log.EBGLogger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SMUtils {
    private static final X9ECParameters sm2p256v1 = GMNamedCurves.getByName((String)"sm2p256v1");
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SMUtils.class);

    public static final String sm2EncryptOperatorPwd(String pub, String opPwd) throws Exception {
        int length = opPwd.length();
        if (length < 10) {
            opPwd = "0" + length + opPwd;
        } else {
            if (length >= 100) {
                return "888";
            }
            opPwd = length + opPwd;
        }
        try {
            return "====================" + Hex.toHexString((byte[])SMUtils.encrypt(Hex.decode((String)pub), opPwd.getBytes()));
        }
        catch (Throwable t) {
            logger.error("\u52a0\u5bc6\u8fc7\u7a0b\u5f02\u5e38", t);
            throw t;
        }
    }

    public static String bytesToHexString(byte[] ba) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < ba.length; ++i) {
            s.append(String.format("%02X", ba[i]));
        }
        return s.toString();
    }

    public static byte[] encrypt(byte[] publicKey, byte[] data) throws Exception {
        if (publicKey.length == 64) {
            byte[] tmp = new byte[65];
            System.arraycopy(publicKey, 0, tmp, 1, publicKey.length);
            tmp[0] = 4;
            publicKey = tmp;
        }
        ECDomainParameters parameters = new ECDomainParameters(sm2p256v1.getCurve(), sm2p256v1.getG(), sm2p256v1.getN());
        ECPublicKeyParameters pubKeyParameters = new ECPublicKeyParameters(sm2p256v1.getCurve().decodePoint(publicKey), parameters);
        SM2Engine engine = new SM2Engine();
        ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)pubKeyParameters, new SecureRandom());
        engine.init(true, (CipherParameters)pwr);
        byte[] cipher = engine.processBlock(data, 0, data.length);
        return SMUtils.encodeSM2CipherToDER(cipher);
    }

    public static byte[] encodeSM2CipherToDER(byte[] cipher) throws IOException {
        int startPos = 1;
        int curveLength = (sm2p256v1.getCurve().getFieldSize() + 7) / 8;
        int digestLength = 32;
        byte[] c1x = new byte[curveLength];
        System.arraycopy(cipher, startPos, c1x, 0, c1x.length);
        byte[] c1y = new byte[curveLength];
        System.arraycopy(cipher, startPos += c1x.length, c1y, 0, c1y.length);
        byte[] c2 = new byte[cipher.length - c1x.length - c1y.length - 1 - digestLength];
        System.arraycopy(cipher, startPos += c1y.length, c2, 0, c2.length);
        byte[] c3 = new byte[digestLength];
        System.arraycopy(cipher, startPos += c2.length, c3, 0, c3.length);
        ASN1Encodable[] arr = new ASN1Encodable[4];
        arr[0] = new ASN1Integer(new BigInteger(1, c1x));
        if (new BigInteger(1, c1x).toByteArray().length < 32) {
            System.out.println("");
        }
        arr[1] = new ASN1Integer(new BigInteger(1, c1y));
        arr[2] = new DEROctetString(c3);
        arr[3] = new DEROctetString(c2);
        DERSequence ds = new DERSequence(arr);
        return ds.getEncoded("DER");
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

