/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.citic.dc.service.note.detail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.citic.dc.service.note.ParserProxy;
import kd.ebg.note.banks.citic.dc.service.note.detail.endorseinfo.EndorseInfoImpl;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLBCMQJB";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subBizType = request.getHeader().getSubBizType();
        if ("hold".equals(subBizType)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6301\u7968\u67e5\u8be2\u3002", (String)"NoteDetailImpl_1", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]));
        }
        if (request.getBody().getTranType().equals("03")) {
            return this.queryReceive(request, "DLTSSPQS");
        }
        if (request.getBody().getTranType().equals("10")) {
            return this.queryReceive(request, "DLBSZRQS");
        }
        if (request.getBody().getTranType().equals("18")) {
            return this.queryReceive(request, "DLZHYAQS");
        }
        if (request.getBody().getTranType().equals("19")) {
            return this.queryReceive(request, "DLZYJCQS");
        }
        if (request.getBody().getTranType().equals("20")) {
            return this.queryReceive(request, "DLTSFKQS");
        }
        if (request.getBody().getTranType().equals("15")) {
            return this.queryReceive(request, "DLTIEXQS");
        }
        if (request.getBody().getTranType().equals("02")) {
            return this.queryReceive(request, "DLTSCDQS");
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7c7b\u578b\u9519\u8bef\uff1atranType=%s\u3002", (String)"NoteDetailImpl_4", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]), request.getBody().getTranType()));
    }

    public String queryReceive(BankNoteDetailRequest request, String type) {
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLBCMQJB");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"reqCode", (String)type);
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)root, (String)"dueDateDown", (String)"");
        JDomUtils.addChild((Element)root, (String)"dueDateUp", (String)"");
        JDomUtils.addChild((Element)root, (String)"billType", (String)request.getBody().getDraftType());
        JDomUtils.addChild((Element)root, (String)"orgName", (String)"");
        JDomUtils.addChild((Element)root, (String)"rcvName", (String)"");
        JDomUtils.addChild((Element)root, (String)"billAmtDown", (String)"");
        JDomUtils.addChild((Element)root, (String)"billAmtUp", (String)"");
        JDomUtils.addChild((Element)root, (String)"ecdsBatNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"odueFlg", (String)"01");
        JDomUtils.addChild((Element)root, (String)"rcrsType", (String)"");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        BankNoteDetailRequestBody body = request.getBody();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5f02\u5e38", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]));
        }
        Element list = root.getChild("list");
        List rows = list.getChildren("row");
        ArrayList<Detail> result = new ArrayList<Detail>(rows.size());
        for (Element rs : rows) {
            Detail detailInfo = new Detail();
            String billNo = rs.getChildTextTrim("billNo");
            detailInfo.setNoteNo(billNo);
            String BILLTYP = rs.getChildTextTrim("BILLTYP");
            detailInfo.setDraftType(BILLTYP);
            String acptDt = rs.getChildText("ISSDATE");
            String dueDt = rs.getChildText("DUEDATE");
            String billMoney = rs.getChildText("PAYAMT");
            String payee = rs.getChildText("PYEENAM");
            String forbidFlag = rs.getChildText("ENDORMK");
            String dfendmk = rs.getChildText("DFENDMK");
            String remitter = rs.getChildText("DRWRNAM");
            String remitterCustBank = rs.getChildText("remitterCustBank");
            String remitterCustBankNo = rs.getChildText("DRWRBNM");
            String endorserName = rs.getChildText("APPNAME");
            String endorserAcctNo = rs.getChildText("APPACCT");
            String fromBankNo = rs.getChildText("APPBNM");
            String payeeBankNo = rs.getChildText("PYEEBNM");
            String acceptor = rs.getChildText("ACCPNAM");
            String acceptorAcct = rs.getChildText("ACCPACC");
            String remitterCustAcct = rs.getChildText("DRWRACC");
            String payeeAcct = rs.getChildText("PYEEACC");
            String APPDATE = rs.getChildText("APPDATE");
            String acceptorBankNo = rs.getChildText("ACCPBNM");
            String bilstat = rs.getChildTextTrim("BILSTAT");
            detailInfo.setNoteStatus(bilstat);
            detailInfo.setIssueDate(acptDt);
            detailInfo.setApplicationDate(APPDATE);
            detailInfo.setDueDate(dueDt);
            if (StringUtils.isEmpty((String)billMoney)) {
                detailInfo.setAmount("0");
            } else {
                detailInfo.setAmount(billMoney);
            }
            if (StringUtils.isEmpty((String)forbidFlag)) {
                detailInfo.setTransferFlag(dfendmk);
            } else {
                detailInfo.setTransferFlag(forbidFlag);
            }
            detailInfo.setPayeeAccName(payee);
            detailInfo.setDrawerAccName(remitter);
            detailInfo.setDrawerAccNo(remitterCustAcct);
            detailInfo.setDrawerBankName(remitterCustBank);
            detailInfo.setDrawerCnapsCode(remitterCustBankNo);
            detailInfo.setPayeeAccNo(payeeAcct);
            detailInfo.setPayeeCnapsCode(payeeBankNo);
            detailInfo.setApplicantAcName(endorserName);
            detailInfo.setApplicantAcNo(endorserAcctNo);
            detailInfo.setApplicantBankCnaps(fromBankNo);
            detailInfo.setAcceptorAccName(acceptor);
            detailInfo.setAcceptorAccNo(acceptorAcct);
            detailInfo.setAcceptorCnapsCode(acceptorBankNo);
            detailInfo.setCurrency("01");
            String BUSSQNO = rs.getChildText("BUSSQNO");
            detailInfo.setBankRefKey(BUSSQNO);
            String subBizType = request.getHeader().getSubBizType();
            if (request.getBody().getTranType().equals("10")) {
                try {
                    EndorseInfoImpl impl = new EndorseInfoImpl();
                    List<NoteSidesInfo> sidesDetails = impl.getinfo(billNo, BUSSQNO, request.getAcnt().getAccNo());
                    detailInfo.setNoteSidesInfo(sidesDetails);
                }
                catch (Throwable t) {
                    this.logger.error("sides error");
                    detailInfo.setIsNoteSidesError("Y");
                }
            }
            result.add(detailInfo);
        }
        return result;
    }
}

