/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.citic.dc.service.note.payable.register;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.citic.dc.service.note.ParserProxy;
import kd.ebg.note.banks.citic.dc.service.note.payable.register.QueryRegisterNotePayableImpl;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RegisterNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRegisterNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLBILREG";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        Element root = new Element("stream");
        List infos = request.getNotePayableInfoList();
        if ("1".equals(((NotePayableInfo)infos.get(0)).getAutoAccept()) && "1".equals(((NotePayableInfo)infos.get(0)).getAutoReceive())) {
            JDomUtils.addChild((Element)root, (String)"action", (String)"DLBLREG3");
        } else if ("1".equals(((NotePayableInfo)infos.get(0)).getAutoAccept())) {
            JDomUtils.addChild((Element)root, (String)"action", (String)"DLBLREG2");
        } else {
            JDomUtils.addChild((Element)root, (String)"action", (String)"DLBILREG");
        }
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)((NotePayableInfo)infos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)((NotePayableInfo)infos.get(0)).getDrawerAccNo());
        JDomUtils.addChild((Element)root, (String)"drwrRate", (String)"");
        JDomUtils.addChild((Element)root, (String)"drwrAgcy", (String)"");
        JDomUtils.addChild((Element)root, (String)"rateDueDate", (String)"");
        JDomUtils.addChild((Element)root, (String)"billType", (String)((NotePayableInfo)infos.get(0)).getDraftType());
        JDomUtils.addChild((Element)root, (String)"issDate", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)root, (String)"dueDate", (String)((NotePayableInfo)infos.get(0)).getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"tranAmt", (String)(((NotePayableInfo)infos.get(0)).getAmount() + ""));
        JDomUtils.addChild((Element)root, (String)"endorseMk", (String)((NotePayableInfo)infos.get(0)).getTransferFlag());
        JDomUtils.addChild((Element)root, (String)"pyeeName", (String)((NotePayableInfo)infos.get(0)).getPayeeAccName());
        JDomUtils.addChild((Element)root, (String)"pyeeAccNo", (String)((NotePayableInfo)infos.get(0)).getPayeeAccNo());
        JDomUtils.addChild((Element)root, (String)"pyeeBnm", (String)((NotePayableInfo)infos.get(0)).getPayeeBankCnaps());
        JDomUtils.addChild((Element)root, (String)"accpName", (String)((NotePayableInfo)infos.get(0)).getAcceptorAccName());
        JDomUtils.addChild((Element)root, (String)"accpAccNo", (String)((NotePayableInfo)infos.get(0)).getAcceptorAccNo());
        JDomUtils.addChild((Element)root, (String)"accpBnm", (String)((NotePayableInfo)infos.get(0)).getAcceptorBankCnaps());
        if ("AC02".equals(((NotePayableInfo)infos.get(0)).getDraftType())) {
            JDomUtils.addChild((Element)root, (String)"accpIsCitic", (String)"1");
        } else {
            JDomUtils.addChild((Element)root, (String)"accpIsCitic", (String)RegisterNotePayableImpl.isSamebank(((NotePayableInfo)infos.get(0)).getAcceptorBankName()));
        }
        JDomUtils.addChild((Element)root, (String)"contractNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"invoiceNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"ecdsBatNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"memo", (String)((NotePayableInfo)infos.get(0)).getExplanation());
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"preDate", (String)"");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public static String isSamebank(String accno) {
        if (StringUtils.isEmpty((String)accno)) {
            return "1";
        }
        if ("1".equals(SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)accno))) {
            return "0";
        }
        return "1";
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return notePayableInfos;
    }
}

