/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.citic.dc.service.note.receivable.endorse;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.citic.dc.service.note.ParserProxy;
import kd.ebg.note.banks.citic.dc.service.note.receivable.endorse.QueryEndorseNoteReceivableImpl;
import kd.ebg.note.banks.citic.dc.service.note.status.CheckOperateReceive;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class EndorseNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryEndorseNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLBSZRSQ";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        boolean flag = new CheckOperateReceive().checkStatus((NoteReceivableInfo)noteReceivableInfos.get(0), "10");
        if (!flag) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ef\u64cd\u4f5c\u7968\u636e\u67e5\u8be2\u8fd4\u56de\u65e0\u6cd5\u80cc\u4e66\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u3002", (String)"EndorseNoteReceivableImpl_0", (String)"ebg-note-banks-citic-dc", (Object[])new Object[0]));
        }
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLBSZRSQ");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)root, (String)"billNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getBillNo());
        JDomUtils.addChild((Element)root, (String)"endorserName", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeAccName());
        JDomUtils.addChild((Element)root, (String)"endorserAccNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeAccNo());
        JDomUtils.addChild((Element)root, (String)"endorserBnm", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeBankCnaps());
        JDomUtils.addChild((Element)root, (String)"endorseMk", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getTransferFlag());
        JDomUtils.addChild((Element)root, (String)"memo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"preDate", (String)"");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return noteReceivableInfos;
    }
}

