/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.citic.dc.service.note.receivable.pledge;

import java.util.List;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.citic.dc.service.note.ParserProxy;
import kd.ebg.note.banks.citic.dc.service.note.receivable.pledge.QueryPledgeNoteReceivableImpl;
import kd.ebg.note.banks.citic.dc.service.note.status.CheckOperateReceive;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class PledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PledgeNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledgeNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLZHYASQ";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        boolean flag = new CheckOperateReceive().checkStatus((NoteReceivableInfo)noteReceivableInfos.get(0), "18");
        if (!flag) {
            throw EBExceiptionUtil.serviceException((String)"");
        }
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLZHYASQ");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"clientID", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)root, (String)"accountNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getDrawerAccNo());
        JDomUtils.addChild((Element)root, (String)"billNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getBillNo());
        JDomUtils.addChild((Element)root, (String)"cobkName", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeAccName());
        JDomUtils.addChild((Element)root, (String)"cobkAccNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeAccNo());
        JDomUtils.addChild((Element)root, (String)"cobkBnm", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeBankCnaps());
        JDomUtils.addChild((Element)root, (String)"cobkIsCitic", (String)PledgeNoteReceivableImpl.isSamebank(((NoteReceivableInfo)noteReceivableInfos.get(0)).getPayeeAccName()));
        JDomUtils.addChild((Element)root, (String)"ecdsBatNo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getOtherInfo());
        JDomUtils.addChild((Element)root, (String)"memo", (String)((NoteReceivableInfo)noteReceivableInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)root, (String)"preFlg", (String)"0");
        JDomUtils.addChild((Element)root, (String)"preDate", (String)"");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public static String isSamebank(String accno) {
        if (StringUtils.isEmpty((String)accno)) {
            return "1";
        }
        return SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)accno);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = ParserProxy.parseResponeCode(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)noteReceivableInfos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return noteReceivableInfos;
    }
}

