/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.detail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.newnote.detail.endorseinfo.EndorseInfoImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class HoldInfoImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(HoldInfoImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NEWEBBHVRQUERYTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6301\u7968\u67e5\u8be2", (String)"NoteDetailImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return "0".equals(noteDetailRequest.getBody().getIsNewECDS());
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        String subRange;
        if (StringUtils.isEmpty((String)pageTag) && "info".equals(request.getHeader().getSubBizType())) {
            pageTag = "1";
        }
        BankNoteDetailRequestBody body = request.getBody();
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBSIGNQUERYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBBHVRQUERYTRNRQ");
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBSIGNQUERYTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBSIGNQUERYTRNRQ, (String)"RQBODY", (String)"PAGE", (String)pageTag);
        EBSIGNQUERYTRNRQ_RQBODY.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"ACCTID", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"BHVRTYPE", (String)"03");
        if (StringUtils.isNotEmpty((String)request.getBody().getNoteNo())) {
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"DRAFTNO", (String)request.getBody().getNoteNo());
        }
        if (StringUtils.isNotEmpty((String)(subRange = request.getBody().getSubRange()))) {
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"DRAFTRANGE", (String)subRange);
        }
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"CANCELLATION", (String)"0");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<Detail> parse(BankNoteDetailRequest rqst, String rspStr) {
        String transType = rqst.getBody().getTranType();
        ArrayList<Detail> result = new ArrayList<Detail>();
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SIGNONMSGSRSV1 = root.getChild("SIGNONMSGSRSV1");
        Element SONRS = SIGNONMSGSRSV1.getChild("SONRS");
        Element STATUS = SONRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("NEWEBBHVRQUERYTRNRS");
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        String more = RSBODY.getAttributeValue("MORE");
        if (RSBODY != null) {
            List contentList = RSBODY.getChildren("CONTENT");
            for (int i = 0; i < contentList.size(); ++i) {
                Detail detailInfo = new Detail();
                detailInfo.setIsNewECDS("0");
                result.add(detailInfo);
                Element rs = (Element)contentList.get(i);
                String BILLCODE = rs.getChildText("DRAFTNO");
                String SUBRANGE = rs.getChildText("DRAFTRANGE");
                String[] subRange = SUBRANGE.split(",");
                String BILLTYPE = rs.getChildText("DRAFTTYPE");
                String BILLAMT = rs.getChildText("DRAFTAMT");
                String SPLITFLAG = rs.getChildText("SPLITFLAG");
                String DRAWDATE = rs.getChildText("ISSUEDATE");
                String DUEDATE = rs.getChildText("DUEDATE");
                Element RSBODY_DRAWERACCT = rs.getChild("DRAWERINFO");
                String ACCTID = RSBODY_DRAWERACCT.getChildText("ACCTID");
                String NAME = RSBODY_DRAWERACCT.getChildText("ACCTNAME");
                String BANKNUM = RSBODY_DRAWERACCT.getChildText("BANKNO");
                String ORGID = RSBODY_DRAWERACCT.getChildText("ORGID");
                String BANKNAME = RSBODY_DRAWERACCT.getChildText("BANKNAME");
                Element RSBODY_PAYEEACCT = rs.getChild("PAYEEINFO");
                String PAY_ACCTID = RSBODY_PAYEEACCT.getChildText("ACCTID");
                String PAY_NAME = RSBODY_PAYEEACCT.getChildText("ACCTNAME");
                String PAY_BANKNUM = RSBODY_PAYEEACCT.getChildText("BANKNO");
                Element RSBODY_ACPTRACCT = rs.getChild("ACPTRINFO");
                String ACP_ACCTID = RSBODY_ACPTRACCT.getChildText("ACCTID");
                String ACP_NAME = RSBODY_ACPTRACCT.getChildText("NAME");
                String ACP_BANKNUM = RSBODY_ACPTRACCT.getChildText("BANKNO");
                String CIBDRAFTSTATUS = rs.getChildText("DRAFTSTATUS");
                String BANENDFLAG = rs.getChildText("BANENDFLAG");
                String TRANSFLAG = rs.getChildText("TRANSFLAG");
                detailInfo.setNoteNo(BILLCODE);
                detailInfo.setDraftType(BILLTYPE);
                detailInfo.setTransferFlag(BANENDFLAG);
                detailInfo.setGrdBag(SPLITFLAG);
                if (subRange != null && subRange.length == 2) {
                    detailInfo.setStartNo(subRange[0]);
                    detailInfo.setEndNo(subRange[1]);
                }
                detailInfo.setCirStatus(TRANSFLAG);
                detailInfo.setSubRange(SUBRANGE);
                detailInfo.setAmount(BILLAMT);
                detailInfo.setNoteStatus(CIBDRAFTSTATUS);
                detailInfo.setPayeeAccName(PAY_NAME);
                detailInfo.setDrawerAccName(NAME);
                detailInfo.setDrawerAccNo(ACCTID);
                detailInfo.setDrawerBankName(BANKNAME);
                detailInfo.setDrawerCnapsCode(BANKNUM);
                detailInfo.setPayeeAccNo(PAY_ACCTID);
                detailInfo.setPayeeCnapsCode(PAY_BANKNUM);
                detailInfo.setAcceptorAccName(ACP_NAME);
                detailInfo.setAcceptorAccNo(ACP_ACCTID);
                detailInfo.setAcceptorCnapsCode(ACP_BANKNUM);
                detailInfo.setCurrency("RMB");
                this.logger.info("transType:" + transType);
                EndorseInfoImpl impl = new EndorseInfoImpl();
                try {
                    List<NoteSidesInfo> sidesDetails = impl.getInfo(BILLCODE, rqst.getAcnt().getAccNo(), SUBRANGE);
                    detailInfo.setNoteSidesInfo(sidesDetails);
                }
                catch (Exception e) {
                    detailInfo.setIsNoteSidesError("Y");
                }
                detailInfo.setBusinessCode(rqst.getBody().getTranType());
            }
        }
        return result;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        return null;
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("NEWEBBHVRQUERYTRNRS");
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        String more = RSBODY.getAttributeValue("MORE");
        return !"Y".equals(more);
    }
}

