/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.detail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.newnote.detail.endorseinfo.EndorseInfoImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RDYRSPQUERYTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u660e\u7ec6\u67e5\u8be2", (String)"NoteDetailImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return "0".equals(noteDetailRequest.getBody().getIsNewECDS());
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        BankNoteDetailRequestBody body = request.getBody();
        String transType = request.getBody().getTranType();
        String type = "";
        if ("02".equals(transType)) {
            type = "BC02";
        } else if ("03".equals(transType)) {
            type = "BC03";
        } else if ("10".equals(transType)) {
            type = "BC07";
        } else if ("18".equals(transType)) {
            type = "BC11";
        } else if ("20".equals(transType)) {
            type = "BC13";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b%s", (String)"NoteDetailImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), transType));
        }
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBSIGNQUERYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"RDYRSPQUERYTRNRQ");
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBSIGNQUERYTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBSIGNQUERYTRNRQ, (String)"RQBODY", (String)"PAGE", (String)pageTag);
        EBSIGNQUERYTRNRQ_RQBODY.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"RDYRSPBIZTYPE", (String)type);
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"ACCTID", (String)request.getAcnt().getAccNo());
        LocalDate startDate = null;
        LocalDate endDate = null;
        if (body.getStartIssueDate() != null && body.getEndIssueDate() != null) {
            startDate = body.getStartIssueDate();
            endDate = body.getEndIssueDate();
        }
        if ((startDate == null || endDate == null) && body.getStartDueDate() != null && body.getEndDueDate() != null) {
            startDate = body.getStartDueDate();
            endDate = body.getEndDueDate();
        }
        if (startDate != null) {
            String dtStart = LocalDateUtil.formatDate((LocalDate)startDate);
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"REQDTSTART", (String)dtStart);
        }
        if (endDate != null) {
            if (endDate.isAfter(LocalDate.now())) {
                endDate = LocalDate.now();
                this.logger.info("\u7ed3\u675f\u65e5\u671f\u5927\u4e8e\u5f53\u5929\uff0c\u6539\u4e3a\u5f53\u5929");
            }
            String dtEnd = LocalDateUtil.formatDate((LocalDate)endDate);
            JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"REQDTEND", (String)dtEnd);
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<Detail> parse(BankNoteDetailRequest rqst, String rspStr) {
        String transType = rqst.getBody().getTranType();
        ArrayList<Detail> result = new ArrayList<Detail>();
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("RDYRSPQUERYTRNRS");
        Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        if (RSBODY != null) {
            List contentList = RSBODY.getChildren("CONTENT");
            for (int i = 0; i < contentList.size(); ++i) {
                Detail detailInfo = new Detail();
                detailInfo.setIsNewECDS("0");
                result.add(detailInfo);
                Element rs = (Element)contentList.get(i);
                String BILLCODE = rs.getChildText("DRAFTNO");
                String SUBRANGE = rs.getChildText("DRAFTRANGE");
                String[] subRange = SUBRANGE.split(",");
                String BILLTYPE = rs.getChildText("DRAFTTYPE");
                String BILLAMT = rs.getChildText("DRAFTAMT");
                String SPLITFLAG = rs.getChildText("SPLITFLAG");
                String DRAWDATE = rs.getChildText("ISSUEDATE");
                String DUEDATE = rs.getChildText("DUEDATE");
                String BIZFLAG = rs.getChildText("RDYRSPBIZNO");
                Element RSBODY_DRAWERACCT = rs.getChild("DRAWERINFO");
                String ACCTID = RSBODY_DRAWERACCT.getChildText("ACCTID");
                String NAME = RSBODY_DRAWERACCT.getChildText("ACCTNAME");
                String BANKNUM = RSBODY_DRAWERACCT.getChildText("BANKNO");
                String ORGID = RSBODY_DRAWERACCT.getChildText("ORGID");
                String BANKNAME = RSBODY_DRAWERACCT.getChildText("BANKNAME");
                Element RSBODY_PAYEEACCT = rs.getChild("PAYEEINFO");
                String PAY_ACCTID = RSBODY_PAYEEACCT.getChildText("ACCTID");
                String PAY_NAME = RSBODY_PAYEEACCT.getChildText("ACCTNAME");
                String PAY_BANKNUM = RSBODY_PAYEEACCT.getChildText("BANKNO");
                Element RSBODY_ACPTRACCT = rs.getChild("ACPTRINFO");
                String ACP_ACCTID = RSBODY_ACPTRACCT.getChildText("ACCTID");
                String ACP_NAME = RSBODY_ACPTRACCT.getChildText("NAME");
                String ACP_BANKNUM = RSBODY_ACPTRACCT.getChildText("BANKNO");
                Element RSBODY_PROPSRINFO = rs.getChild("REQINFO");
                String PRO_ACCTID = RSBODY_PROPSRINFO.getChildText("ACCTID");
                String PRO_NAME = RSBODY_PROPSRINFO.getChildText("ACCTNAME");
                String PRO_BANKNUM = RSBODY_PROPSRINFO.getChildText("BANKNO");
                String CIBDRAFTSTATUS = rs.getChildText("DRAFTSTATUS");
                String BANENDFLAG = rs.getChildText("BANENDFLAG");
                String TRANSFLAG = rs.getChildText("TRANSFLAG");
                String REQDATE = rs.getChildText("REQDATE");
                String lqmode = rs.getChildText("LQMODE");
                if (StringUtils.isEmpty((String)detailInfo.getReserved2())) {
                    detailInfo.setReserved2(lqmode);
                }
                detailInfo.setNoteNo(BILLCODE);
                detailInfo.setDraftType(BILLTYPE);
                detailInfo.setTransferFlag(BANENDFLAG);
                detailInfo.setIssueDate(DRAWDATE);
                detailInfo.setDueDate(DUEDATE);
                detailInfo.setGrdBag(SPLITFLAG);
                if (subRange != null && subRange.length == 2) {
                    detailInfo.setStartNo(subRange[0]);
                    detailInfo.setEndNo(subRange[1]);
                }
                detailInfo.setCirStatus(TRANSFLAG);
                detailInfo.setSubRange(SUBRANGE);
                detailInfo.setAmount(BILLAMT);
                detailInfo.setNoteStatus(CIBDRAFTSTATUS);
                detailInfo.setPayeeAccName(PAY_NAME);
                detailInfo.setDrawerAccName(NAME);
                detailInfo.setDrawerAccNo(ACCTID);
                detailInfo.setDrawerBankName(BANKNAME);
                detailInfo.setDrawerCnapsCode(BANKNUM);
                detailInfo.setPayeeAccNo(PAY_ACCTID);
                detailInfo.setPayeeCnapsCode(PAY_BANKNUM);
                detailInfo.setApplicantAcName(PRO_NAME);
                detailInfo.setApplicantAcNo(PRO_ACCTID);
                detailInfo.setApplicantBankCnaps(PRO_BANKNUM);
                if (StringUtils.isNotEmpty((String)REQDATE)) {
                    detailInfo.setApplicationDate(REQDATE);
                }
                detailInfo.setAcceptorAccName(ACP_NAME);
                detailInfo.setAcceptorAccNo(ACP_ACCTID);
                detailInfo.setAcceptorCnapsCode(ACP_BANKNUM);
                detailInfo.setCurrency("RMB");
                detailInfo.setBankRefKey(BIZFLAG);
                this.logger.info("transType:" + transType);
                EndorseInfoImpl impl = new EndorseInfoImpl();
                try {
                    List<NoteSidesInfo> sidesDetails = impl.getInfo(BILLCODE, rqst.getAcnt().getAccNo(), SUBRANGE);
                    detailInfo.setNoteSidesInfo(sidesDetails);
                }
                catch (Exception e) {
                    detailInfo.setIsNoteSidesError("Y");
                }
                detailInfo.setBusinessCode(rqst.getBody().getTranType());
            }
        }
        return result;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        return Integer.parseInt(pageTag) + 1 + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("RDYRSPQUERYTRNRS");
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        String more = RSBODY.getAttributeValue("MORE");
        return !"Y".equals(more);
    }
}

