/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.detail.endorseinfo;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.newnote.detail.endorseinfo.Page;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class EndorseInfoImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseInfoImpl.class);

    public List<NoteSidesInfo> getInfo(String billNo, String accno, String subrange) {
        ArrayList<NoteSidesInfo> list = new ArrayList<NoteSidesInfo>();
        try {
            String rspStr = "";
            Page page = new Page();
            String pageTag = page.getFirstPageTag();
            do {
                String rqstStr = this.packNoteInfoRequest(billNo, pageTag, accno, subrange);
                this.logger.info("\u80cc\u4e66\u8054\u67e5\u8be2\u7684\u8bf7\u6c42\u6570\u636e\uff1a" + rqstStr);
                ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
                String encoding = RequestContextUtils.getCharset();
                factory.setHttpHeader("content-type", "text/xml; charset=" + encoding);
                IConnection conn = factory.createExchangeConnection();
                conn.openConnection();
                OutputStream os = conn.getOutputStream();
                IOUtils.sendFully((OutputStream)os, (String)rqstStr);
                IOUtils.closeOutputStreamQuietly((OutputStream)os);
                InputStream is = conn.getInputStream();
                rspStr = IOUtils.readFully((InputStream)is);
                list.addAll(this.parserNoteInfoResponse(rspStr));
                IOUtils.closeInputStreamQuietly((InputStream)is);
                conn.closeConnection();
            } while (!page.isLastPage(pageTag = page.getNextPageTag(rspStr, pageTag)));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return list;
    }

    public String packNoteInfoRequest(String billNo, String pageTap, String accno, String subrange) {
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBBACKQUERYTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBBACKQUERYTRNRQ");
        JDomUtils.addChild((Element)EBBACKQUERYTRNRQ, (String)"TRNUID", (String)TRNUID);
        String pageNo = pageTap.substring(0, pageTap.indexOf("_"));
        Element EBSIGNQUERYTRNRQ_RQBODY = JDomUtils.addChildAttribute((Element)EBBACKQUERYTRNRQ, (String)"RQBODY", (String)"PAGE", (String)pageNo);
        EBSIGNQUERYTRNRQ_RQBODY.setAttribute("SIZE", "100");
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"DRAFTNO", (String)billNo);
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"ACCTID", (String)accno);
        JDomUtils.addChild((Element)EBSIGNQUERYTRNRQ_RQBODY, (String)"DRAFTRANGE", (String)subrange);
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteSidesInfo> parserNoteInfoResponse(String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("NEWEBBACKQUERYTRNRS");
        Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        ArrayList<NoteSidesInfo> result = new ArrayList<NoteSidesInfo>();
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        if (RSBODY == null) {
            return result;
        }
        List contentList = RSBODY.getChildren("CONTENT");
        for (int i = 0; i < contentList.size(); ++i) {
            NoteSidesInfo detail = new NoteSidesInfo();
            Element rs = (Element)contentList.get(i);
            String BUSINESSTYPE = rs.getChildText("BEHAVETYPE");
            String SIGNDATE = rs.getChildText("BEHAVEDATE");
            Element PROPSR = rs.getChild("REQINFO");
            String PROPSRNAME = PROPSR.getChildText("ACCTNAME");
            String PROPSRACCTID = PROPSR.getChildText("ACCTID");
            Element RCVRR = rs.getChild("RSPINFO");
            String RCVRRACCTID = RCVRR.getChildText("ACCTID");
            String RCVRRNAME = RCVRR.getChildText("ACCTNAME");
            String BANENDFLAG = rs.getChildText("BANENDFLAG");
            detail.setInitiatorName(PROPSRNAME);
            detail.setInitiatorAcNo(PROPSRACCTID);
            detail.setOpponentName(RCVRRNAME);
            detail.setOpponentAcNo(RCVRRACCTID);
            if (!StringUtils.isEmpty((String)SIGNDATE)) {
                detail.setSignDate(SIGNDATE);
            }
            detail.setResv1(i + "");
            detail.setTransferFlag(BANENDFLAG);
            if ("ET05".equals(BUSINESSTYPE)) {
                detail.setBusinessCode("10");
                result.add(detail);
                continue;
            }
            if ("ET03".equals(BUSINESSTYPE)) {
                detail.setBusinessCode("18");
                result.add(detail);
                continue;
            }
            if (!"ET04".equals(BUSINESSTYPE)) continue;
            detail.setBusinessCode("19");
            result.add(detail);
        }
        this.logger.info("\u83b7\u53d6\u5230\u7684\u80cc\u9762\u6570\u91cf\uff1a" + result.size());
        return result;
    }
}

