/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.payable.cancel;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.CommonPacker;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.payable.QueryNotePayableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CancelNoteImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NEWEBRECEDETRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u64a4\u9500\u7533\u8bf7", (String)"CancelNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBRECEDETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBRECEDETRNRQ");
        JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBRECEDETRNRQ_RQBODY = JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        Map<String, String> map = null;
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            try {
                NoteReceivableInfo noteReceivableInfo = new NoteReceivableInfo();
                noteReceivableInfo.setOperationCode(notePayableInfo.getOperationCode());
                noteReceivableInfo.setBillNo(notePayableInfo.getBillNo());
                noteReceivableInfo.setDrawerAccNo(notePayableInfo.getDrawerAccNo());
                noteReceivableInfo.setDraftType(notePayableInfo.getDraftType());
                noteReceivableInfo.setSubRange(notePayableInfo.getSubRange());
                map = CommonPacker.getSeqInfoNew(noteReceivableInfo);
                if (map.get("SEQ") == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be5\u7968\u636e\u4e0d\u53ef\u64a4\u9500\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001\uff01", (String)"CancelNoteImpl_5", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5728\u67e5\u8be2\u53ef\u64cd\u4f5c\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%s", (String)"CancelNoteImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), e.getMessage()));
            }
            String operationCode = notePayableInfo.getOperationCode();
            String BUSINESSTYPE = "";
            if ("02".equals(operationCode)) {
                BUSINESSTYPE = "BC02";
            } else if ("03".equals(operationCode)) {
                BUSINESSTYPE = "BC03";
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a%s", (String)"CancelNoteImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operationCode));
            }
            notePayableInfo.setReserved1(TRNUID);
            Element CONTENT = JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)CONTENT, (String)"DRAFTNO", (String)notePayableInfo.getBillNo());
            JDomUtils.addChild((Element)CONTENT, (String)"DRAFTRANGE", (String)NoteHandlerHelper.getFixSubBillRng(notePayableInfo));
            JDomUtils.addChild((Element)CONTENT, (String)"DRAFTAMT", (String)(notePayableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)CONTENT, (String)"BIZTYPE", (String)BUSINESSTYPE);
            JDomUtils.addChild((Element)CONTENT, (String)"BIZNO", (String)map.get("SEQ"));
            JDomUtils.addChild((Element)CONTENT, (String)"REMARK", (String)notePayableInfo.getExplanation());
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return notePayableInfos;
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBRECEDETRNRS = eb1.getChild("NEWEBRECEDETRNRS");
        Element STATUS = EBRECEDETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)MESSAGE);
        }
        return notePayableInfos;
    }
}

