/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.receivable.cancel;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.CommonPacker;
import kd.ebg.note.banks.cib.dc.services.newnote.NoteHandlerHelper;
import kd.ebg.note.banks.cib.dc.services.newnote.receivable.QueryNoteReceivableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivableCancelNoteImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceivableCancelNoteImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "NEWEBRECEDETRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u64a4\u9500", (String)"ReceivableCancelNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        NoteReceivableInfo[] receivableInfos = bankNoteReceivableRequest.getNotePayableInfosAsArray();
        NoteReceivableInfo info = receivableInfos[0];
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBRECEDETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBRECEDETRNRQ");
        JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBRECEDETRNRQ_RQBODY = JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        Map<String, String> map = null;
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            try {
                map = CommonPacker.getSeqInfoNew(noteReceivableInfo);
                if (map.get("SEQ") == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8be5\u7968\u636e\u4e0d\u53ef\u64a4\u9500\uff0c\u8bf7\u6838\u5b9e\u7968\u636e\u72b6\u6001\uff01", (String)"ReceivableCancelNoteImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5728\u67e5\u8be2\u53ef\u64cd\u4f5c\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%s", (String)"ReceivableCancelNoteImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), e.getMessage()));
            }
            String operationCode = noteReceivableInfo.getOperationCode();
            String BUSINESSTYPE = "";
            if ("10".equals(operationCode)) {
                BUSINESSTYPE = "BC07";
            } else if ("18".equals(operationCode)) {
                BUSINESSTYPE = "BC11";
            } else if ("19".equals(operationCode)) {
                BUSINESSTYPE = "BC12";
            } else if ("20".equals(operationCode)) {
                BUSINESSTYPE = "BC13";
            } else if ("11".equals(operationCode)) {
                BUSINESSTYPE = "BC08";
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a%s", (String)"ReceivableCancelNoteImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operationCode));
            }
            noteReceivableInfo.setReserved1(TRNUID);
            Element CONTENT = JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)CONTENT, (String)"DRAFTNO", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)CONTENT, (String)"DRAFTRANGE", (String)NoteHandlerHelper.getFixSubBillRng(noteReceivableInfo));
            JDomUtils.addChild((Element)CONTENT, (String)"DRAFTAMT", (String)(noteReceivableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)CONTENT, (String)"BIZTYPE", (String)BUSINESSTYPE);
            JDomUtils.addChild((Element)CONTENT, (String)"BIZNO", (String)map.get("SEQ"));
            JDomUtils.addChild((Element)CONTENT, (String)"REMARK", (String)noteReceivableInfo.getExplanation());
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(rsp);
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return receivableInfos;
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBRECEDETRNRS = eb1.getChild("NEWEBRECEDETRNRS");
        Element STATUS = EBRECEDETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)MESSAGE);
        }
        return receivableInfos;
    }
}

