/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.newnote.receivable.repledge;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class ReceivableRepledgeNoteImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return null;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NEWEBIMPAWNCANCLTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u89e3\u9664\u8d28\u62bc", (String)"ReceivableRepledgeNoteImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        BankAcnt acnt = RequestContextUtils.getRequestContext().getAcnt();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBIMPAWNTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"NEWEBIMPAWNCANCLTRNRQ");
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen14Sequence();
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBIMPAWNTRNRQ_RQBODY = JDomUtils.addChild((Element)EBIMPAWNTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"ACCTID", (String)acnt.getAccNo());
        for (NoteReceivableInfo noteReceivableInfo : receivableInfos) {
            noteReceivableInfo.setReserved1(TRNUID);
            Element RQBODY_CONTENT = JDomUtils.addChild((Element)EBIMPAWNTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTNO", (String)noteReceivableInfo.getBillNo());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTRANGE", (String)noteReceivableInfo.getSubRange());
            JDomUtils.addChild((Element)RQBODY_CONTENT, (String)"DRAFTAMT", (String)(noteReceivableInfo.getAmount() + ""));
        }
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rsp) {
        List receivableInfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        Element root = CIB_DC_Parser.parseString2Root(rsp);
        BankResponse bankResponse = CIB_DC_Parser.noteParseString2Root(root);
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return receivableInfos;
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBIMPAWNTRNRS = eb1.getChild("NEWEBIMPAWNCANCLTRNRS");
        Element STATUS = EBIMPAWNTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.FAIL, (String)code, (String)MESSAGE);
        } else {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ReceivableRepledgeNoteImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
        return receivableInfos;
    }
}

