/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.detail.endorseinfo;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteInfoParser {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteInfoParser.class);

    public List<NoteSidesInfo> parserNoteInfoResponse(String rspStr) throws ParseException {
        this.logger.info("\u660e\u7ec6\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element SECURITIES_MSGSRSV1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBSIGNQUERYTRNRS = SECURITIES_MSGSRSV1.getChild("EBBACKQUERYTRNRS");
        Element STATUS = EBSIGNQUERYTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)MESSAGE);
        }
        ArrayList<NoteSidesInfo> result = new ArrayList<NoteSidesInfo>();
        Element RSBODY = EBSIGNQUERYTRNRS.getChild("RSBODY");
        if (RSBODY == null) {
            return result;
        }
        List contentList = RSBODY.getChildren("CONTENT");
        for (int i = 0; i < contentList.size(); ++i) {
            NoteSidesInfo detail = new NoteSidesInfo();
            Element rs = (Element)contentList.get(i);
            String BUSINESSTYPE = rs.getChildText("BUSINESSTYPE");
            String SIGNDATE = rs.getChildText("SIGNDATE");
            Element PROPSR = rs.getChild("PROPSR");
            String PROPSRNAME = PROPSR.getChildText("NAME");
            String PROPSRACCTID = PROPSR.getChildText("ACCTID");
            Element RCVRR = rs.getChild("RCVRR");
            String RCVRRACCTID = RCVRR.getChildText("ACCTID");
            String RCVRRNAME = RCVRR.getChildText("NAME");
            String NEGTBL = rs.getChildText("NEGTBL");
            detail.setInitiatorName(PROPSRNAME);
            detail.setInitiatorAcNo(PROPSRACCTID);
            detail.setOpponentName(RCVRRNAME);
            detail.setOpponentAcNo(RCVRRACCTID);
            if (!StringUtils.isEmpty((String)SIGNDATE)) {
                detail.setSignDate(SIGNDATE);
            }
            detail.setResv1(i + "");
            detail.setTransferFlag(NEGTBL);
            if ("07".equals(BUSINESSTYPE)) {
                detail.setBusinessCode("10");
                result.add(detail);
                continue;
            }
            if ("15".equals(BUSINESSTYPE)) {
                detail.setBusinessCode("18");
                result.add(detail);
                continue;
            }
            if (!"16".equals(BUSINESSTYPE)) continue;
            detail.setBusinessCode("19");
            result.add(detail);
        }
        this.logger.info("\u83b7\u53d6\u5230\u7684\u80cc\u9762\u6570\u91cf\uff1a" + result.size());
        return result;
    }
}

