/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.payable.cancel;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.CommonPacker;
import kd.ebg.note.banks.cib.dc.services.note.payable.cancel.QueryCancleNotePayableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CancleNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNotePayableImpl.class);

    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryCancleNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBRECEDETRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBRECEDETRNRQ");
        JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBRECEDETRNRQ_RQBODY = JDomUtils.addChild((Element)EBRECEDETRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"TOTALAMT");
        JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        Map<String, String> map = null;
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            try {
                NoteReceivableInfo noteReceivableInfo = new NoteReceivableInfo();
                noteReceivableInfo.setOperationCode(notePayableInfo.getOperationCode());
                noteReceivableInfo.setBillNo(notePayableInfo.getBillNo());
                noteReceivableInfo.setDrawerAccNo(notePayableInfo.getDrawerAccNo());
                noteReceivableInfo.setDraftType(notePayableInfo.getDraftType());
                map = CommonPacker.getSeqInfo(noteReceivableInfo);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5728\u67e5\u8be2\u53ef\u64cd\u4f5c\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (String)"CancleNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (Throwable)e);
            }
            String operationCode = notePayableInfo.getOperationCode();
            String BUSINESSTYPE = "";
            if ("02".equals(operationCode)) {
                BUSINESSTYPE = "22";
            } else if ("03".equals(operationCode)) {
                BUSINESSTYPE = "23";
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64a4\u9500\u7c7b\u578b\uff1a%s", (String)"CancleNotePayableImpl_4", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), operationCode));
            }
            notePayableInfo.setRqstserialno(TRNUID);
            Element CONTENT = JDomUtils.addChild((Element)EBRECEDETRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)CONTENT, (String)"BILLCODE", (String)notePayableInfo.getBillNo());
            JDomUtils.addChild((Element)CONTENT, (String)"BILLAMT", (String)(notePayableInfo.getAmount() + ""));
            JDomUtils.addChild((Element)CONTENT, (String)"BUSINESSTYPE", (String)BUSINESSTYPE);
            JDomUtils.addChild((Element)CONTENT, (String)"BIZFLAG", (String)map.get("BIZFLAG"));
            JDomUtils.addChild((Element)CONTENT, (String)"SEQ", (String)map.get("SEQ"));
            JDomUtils.addChild((Element)CONTENT, (String)"APPDATE", (String)map.get("APPDATE"));
            totalAmt = totalAmt.add(notePayableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBRECEDETRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBRECEDETRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        this.logger.info("\u64a4\u9500\u62a5\u6587\uff1a" + str);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBRECEDETRNRS = eb1.getChild("EBRECEDETRNRS");
        Element STATUS = EBRECEDETRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        this.logger.info("code:" + code + ",MESSAGE:" + MESSAGE);
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)MESSAGE);
        } else {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CancleNotePayableImpl_2", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
        return notePayableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u9500", (String)"CancleNotePayableImpl_3", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

