/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cib.dc.services.note.payable.revocation;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.cib.dc.services.note.payable.revocation.QueryRevocationNotePayableImpl;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Packer;
import kd.ebg.note.banks.cib.dc.services.util.CIB_DC_Parser;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class RevocationNotePayableImpl
extends AbstractNotePayableImpl {
    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryRevocationNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayableInfos = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        String TRNUID = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd") + Sequence.gen16Sequence();
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element EBCANCLTRNRQ = JDomUtils.addChild((Element)msgsv, (String)"EBCANCLTRNRQ");
        JDomUtils.addChild((Element)EBCANCLTRNRQ, (String)"TRNUID", (String)TRNUID);
        Element EBCANCLTRNRQ_RQBODY = JDomUtils.addChild((Element)EBCANCLTRNRQ, (String)"RQBODY");
        JDomUtils.addChild((Element)EBCANCLTRNRQ_RQBODY, (String)"TOTALCOUNT");
        JDomUtils.addChild((Element)EBCANCLTRNRQ_RQBODY, (String)"TOTALAMT");
        JDomUtils.addChild((Element)EBCANCLTRNRQ_RQBODY, (String)"BILLTYPE", (String)info.getDraftType());
        JDomUtils.addChild((Element)EBCANCLTRNRQ_RQBODY, (String)"ACCTID", (String)info.getDrawerAccNo());
        int count = 0;
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (NotePayableInfo notePayableInfo : notePayableInfos) {
            notePayableInfo.setRqstserialno(TRNUID);
            Element EBCANCLTRNRQ_CONTENT = JDomUtils.addChild((Element)EBCANCLTRNRQ_RQBODY, (String)"CONTENT");
            JDomUtils.addChild((Element)EBCANCLTRNRQ_CONTENT, (String)"INDX", (String)(++count + ""));
            JDomUtils.addChild((Element)EBCANCLTRNRQ_CONTENT, (String)"BILLCODE", (String)notePayableInfo.getBillNo());
            JDomUtils.addChild((Element)EBCANCLTRNRQ_CONTENT, (String)"BILLAMT", (String)(notePayableInfo.getAmount() + ""));
            totalAmt = totalAmt.add(notePayableInfo.getAmount());
        }
        JDomUtils.getChildElement((Element)EBCANCLTRNRQ_RQBODY, (String)"TOTALCOUNT").addContent(count + "");
        JDomUtils.getChildElement((Element)EBCANCLTRNRQ_RQBODY, (String)"TOTALAMT").addContent(totalAmt + "");
        String encoding = RequestContextUtils.getCharset();
        String str = JDomUtils.root2String((Element)cms, (String)encoding);
        return str;
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayableInfos = request.getNotePayableInfoList();
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element EBCANCLTRNRS = eb1.getChild("EBCANCLTRNRS");
        Element STATUS = EBCANCLTRNRS.getChild("STATUS");
        String code = JDomUtils.getChildText((Element)STATUS, (String)"CODE");
        String MESSAGE = JDomUtils.getChildText((Element)STATUS, (String)"MESSAGE");
        if (!"0".equals(code)) {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RevocationNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        } else {
            EBGNotePayableUtils.setPaymentState((List)notePayableInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"RevocationNotePayableImpl_0", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]), (String)MESSAGE);
        }
        return notePayableInfos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u7968", (String)"RevocationNotePayableImpl_1", (String)"ebg-note-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public long getBankInterval() {
        return 0L;
    }
}

