/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.note.detail.endorseInfo.EndorseInfoImpl;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgParser;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;

public class NoteDetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(NoteDetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "replyabletrsqry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u4fe1\u606f\u67e5\u8be2", (String)"NoteDetailImpl_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        List<Detail> infos = new ArrayList<Detail>(16);
        try {
            String pageTag = this.getFirstPageTag();
            String responseStr = "";
            do {
                String rqstStr;
                if ((responseStr = PostUtil.sendMsg(rqstStr = this.pack(request, pageTag))).contains("ErrMsg")) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"NoteDetailImpl_4", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), responseStr));
                }
                responseStr = MsgParser.getReceMsg(responseStr, this.logger);
                infos.addAll(this.parse(request, responseStr));
            } while (!this.isLastPage(responseStr, pageTag = this.getNextPageTag(responseStr, pageTag)));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        infos = this.setData(request, infos);
        return new EBBankDetailResponse(infos);
    }

    public List<Detail> setData(BankNoteDetailRequest request, List<Detail> details) {
        String isNewECDS = request.getBody().getIsNewECDS();
        for (Detail detail : details) {
            detail.setIsNewECDS(isNewECDS);
        }
        return details;
    }

    public String pack(BankNoteDetailRequest request, String pageTag) {
        BankAcnt acnt = request.getAcnt();
        JSONObject body = new JSONObject();
        JSONArray array1 = new JSONArray();
        JSONObject qryHdr = new JSONObject();
        qryHdr.put("flwTyp", (Object)"ND0010");
        qryHdr.put("oprAcc", (Object)acnt.getAccNo());
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            qryHdr.put("cltNbr", (Object)cltNbr);
        } else {
            qryHdr.put("cltNbr", (Object)acnt.getAccNo().substring(0, 10));
        }
        array1.add((Object)qryHdr);
        body.put("qryHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject replyCltBilInfoInpDto = new JSONObject();
        replyCltBilInfoInpDto.put("cltEac", (Object)acnt.getAccNo());
        if (!StringUtils.isEmpty((String)request.getBody().getDraftType())) {
            replyCltBilInfoInpDto.put("bilTyp", (Object)request.getBody().getDraftType());
        }
        replyCltBilInfoInpDto.put("bilSrc", (Object)"CS02");
        String bustype = "";
        if ("02".equals(request.getBody().getTranType())) {
            bustype = "BC02";
        } else if ("03".equals(request.getBody().getTranType())) {
            bustype = "BC03";
        } else if ("10".equals(request.getBody().getTranType())) {
            bustype = "BC07";
        } else if ("11".equals(request.getBody().getTranType())) {
            bustype = "BC08";
        } else if ("18".equals(request.getBody().getTranType())) {
            bustype = "BC11";
        } else if ("20".equals(request.getBody().getTranType())) {
            bustype = "BC13";
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7684\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2", (String)"NoteDetailImpl_6", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        replyCltBilInfoInpDto.put("busCod", (Object)bustype);
        replyCltBilInfoInpDto.put("pageSize", (Object)"200");
        replyCltBilInfoInpDto.put("pageNum", (Object)(Integer.parseInt(pageTag) + ""));
        array2.add((Object)replyCltBilInfoInpDto);
        body.put("replyCltBilInfoInpDto", (Object)array2);
        JSONObject head = JsonUtil.getHead("replyabletrsqry", Sequence.genSequence());
        JSONObject result = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(result, this.logger, "replyabletrsqry");
    }

    public List<Detail> parse(BankNoteDetailRequest bankNoteDetailRequest, String rspStr) {
        BankAcnt acnt = bankNoteDetailRequest.getAcnt();
        ArrayList<Detail> result = new ArrayList<Detail>(16);
        BankResponse response = MsgParser.getResponse(rspStr, this.logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"NoteDetailImpl_4", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)rspStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray replyCltBilInfoOutDto = body.getJSONArray("replyCltBilInfoOutDto");
        if (replyCltBilInfoOutDto == null || replyCltBilInfoOutDto.size() == 0) {
            return result;
        }
        EndorseInfoImpl impl = new EndorseInfoImpl();
        for (int i = 0; i < replyCltBilInfoOutDto.size(); ++i) {
            JSONObject obiect = replyCltBilInfoOutDto.getJSONObject(i).getJSONObject("billFrontInfoEdcDto");
            JSONObject other = replyCltBilInfoOutDto.getJSONObject(i).getJSONObject("cltTrsReplyInfoDto");
            Detail info = new Detail();
            String bilNbr = obiect.getString("bilNbr");
            info.setNoteNo(bilNbr);
            String divFlg = obiect.getString("divFlg");
            if (divFlg.equals("Y")) {
                info.setGrdBag("1");
            } else {
                info.setGrdBag("0");
            }
            String bilSbs = obiect.getString("bilSbs");
            info.setStartNo(bilSbs);
            String bilSbe = obiect.getString("bilSbe");
            info.setEndNo(bilSbe);
            info.setSubRange(bilSbs + "-" + bilSbe);
            info.setCurrency("10");
            String bilTyp = obiect.getString("bilTyp");
            info.setDraftType(bilTyp);
            String isuDat = obiect.getString("isuDat");
            info.setIssueDate(isuDat);
            String dueDat = obiect.getString("dueDat");
            info.setDueDate(dueDat);
            BigDecimal subAmt = obiect.getBigDecimal("bilAmt");
            info.setAmount(subAmt.toPlainString());
            String bilSts = obiect.getString("bilSts");
            info.setNoteStatus(bilSts);
            String trdSts = obiect.getString("trdSts");
            info.setCirStatus(trdSts);
            info.setIsNewECDS("0");
            String bilTrf = obiect.getString("bilTrf");
            info.setTransferFlag(bilTrf);
            String bilRmk = obiect.getString("bilRmk");
            info.setExplain(bilRmk);
            String drwBrd = obiect.getString("drwBrd");
            info.setDrawerCnapsCode(drwBrd);
            String drwBdn = obiect.getString("drwBdn");
            info.setDrawerBankName(drwBdn);
            String drwAcc = obiect.getString("drwAcc");
            info.setDrawerAccNo(drwAcc);
            String drwAcn = obiect.getString("drwAcn");
            info.setDrawerAccName(drwAcn);
            String acpBrd = obiect.getString("acpBrd");
            info.setAcceptorCnapsCode(acpBrd);
            String acpBdn = obiect.getString("acpBdn");
            info.setAcceptorBankName(acpBdn);
            String acpAcc = obiect.getString("acpAcc");
            info.setAcceptorAccNo(acpAcc);
            String acpAcn = obiect.getString("acpAcn");
            info.setAcceptorAccName(acpAcn);
            String pyeBrd = obiect.getString("pyeBrd");
            info.setPayeeCnapsCode(pyeBrd);
            String pyeBdn = obiect.getString("pyeBdn");
            info.setPayeeBankName(pyeBdn);
            String pyeAcc = obiect.getString("pyeAcc");
            info.setPayeeAccNo(pyeAcc);
            String pyeAcn = obiect.getString("pyeAcn");
            info.setPayeeAccName(pyeAcn);
            info.setBusinessCode(bankNoteDetailRequest.getBody().getTranType());
            if (bankNoteDetailRequest.getBody().getTranType().equals("10")) {
                try {
                    List<NoteSidesInfo> list = impl.getmessage(info, acnt);
                    info.setNoteSidesInfo(list);
                }
                catch (Exception e) {
                    info.setIsNoteSidesError("Y");
                }
            }
            if (bankNoteDetailRequest.getBody().getTranType().equals("02") || bankNoteDetailRequest.getBody().getTranType().equals("03")) {
                info.setApplicantAcNo(drwAcc);
                info.setApplicantAcName(drwAcn);
                info.setApplicantBankName(drwBdn);
                info.setApplicantBankCnaps(drwBrd);
                info.setHolderAccNo(drwAcc);
                info.setPreHolderName(drwAcn);
                info.setHolderBankName(drwBdn);
                info.setHolderCnapsCode(drwBrd);
            } else {
                String opcEac = other.getString("opcEac");
                info.setApplicantAcNo(opcEac);
                String opcNam = other.getString("opcNam");
                info.setApplicantAcName(opcNam);
                String opcBdn = other.getString("opcBdn");
                info.setApplicantBankName(opcBdn);
                info.setHolderAccNo(opcEac);
                info.setPreHolderName(opcNam);
                info.setHolderBankName(opcBdn);
            }
            String busSeq = other.getString("busSeq");
            String innNbr = other.getString("innNbr");
            String prdIst = other.getString("prdIst");
            String busCod = other.getString("busCod");
            info.setBankRefKey(busSeq + "|" + innNbr + "|" + prdIst + "|" + busCod);
            result.add(info);
        }
        return result;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        return "" + (Integer.parseInt(pageTag) + 1);
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        JSONObject request = JSONObject.parseObject((String)rspStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONArray ntrbptrsz1 = body.getJSONArray("srchPageZ1");
        JSONObject first = (JSONObject)ntrbptrsz1.get(0);
        String pages = first.getString("pages");
        int page = Integer.parseInt(pages);
        return Integer.parseInt(pageTag) - 1 >= page;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isNeedPage() {
        return true;
    }
}

