/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.receivable.cancle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.receivable.cancle.QueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.util.AvaiableCancleQuery;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.ParserReceivable;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SaasUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class CancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CancleNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleNoteReceivableImpl.class;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "combuscancel";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u7533\u8bf7\u64a4\u56de\u3002", (String)"CancleNoteReceivableImpl_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        String rqstStr = this.pack(request, null);
        String rspStr = PostUtil.sendMsgForPay(rqstStr);
        try {
            List<NoteReceivableInfo> infos = this.parse(request, rspStr);
            return new EBBankNoteReceivableResponse(infos);
        }
        catch (Exception e) {
            this.logger.error("error ", (Throwable)e);
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankNoteReceivableResponse(request.getNoteReceivableInfos());
        }
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        BankAcnt acnt = request.getAcnt();
        NoteReceivableInfo[] receivableInfos = request.getNotePayableInfosAsArray();
        String code = receivableInfos[0].getOperationCode();
        String type = "";
        if ("10".equals(code)) {
            code = "BC07";
            type = "03";
        } else if ("11".equals(code)) {
            code = "BC08";
            type = "04";
        } else if ("18".equals(code)) {
            code = "BC11";
            type = "07";
        } else if ("20".equals(code)) {
            code = "BC13";
            type = "09";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7968\u636e\u7c7b\u578b\u4fe1\u606f\u67e5\u8be2\uff1a%s\u3002", (String)"CancleNoteReceivableImpl_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]), code));
        }
        AvaiableCancleQuery avaiable = new AvaiableCancleQuery();
        Map flag = avaiable.getmsg(receivableInfos[0].getDrawerAccNo(), code, receivableInfos[0].getBillNo(), receivableInfos[0].getStartNo(), receivableInfos[0].getEndNo());
        if (flag == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6b64\u7968\u636e\u4e0d\u80fd\u64a4\u9500\u3002", (String)"CancleNoteReceivableImpl_2", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        this.logger.info("\u901a\u7528\u64a4\u9500");
        JSONObject body = new JSONObject();
        JSONArray array1 = new JSONArray();
        JSONObject qryHdr = new JSONObject();
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            qryHdr.put("cltNbr", (Object)cltNbr);
        } else {
            qryHdr.put("cltNbr", (Object)acnt.getAccNo().substring(0, 10));
        }
        array1.add((Object)qryHdr);
        body.put("trxHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject cltTrsDetailEdcInpDto = new JSONObject();
        cltTrsDetailEdcInpDto.put("cnlRef", (Object)SaasUtil.getRnlRef(receivableInfos[0].getBankBatchSeqId()));
        cltTrsDetailEdcInpDto.put("flwTyp", (Object)"ND0010");
        cltTrsDetailEdcInpDto.put("busTyp", (Object)"PB");
        cltTrsDetailEdcInpDto.put("busSty", (Object)"03");
        cltTrsDetailEdcInpDto.put("busTrs", (Object)"DFT");
        cltTrsDetailEdcInpDto.put("busStr", (Object)receivableInfos[0].getDraftType());
        cltTrsDetailEdcInpDto.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        cltTrsDetailEdcInpDto.put("sndEac", (Object)receivableInfos[0].getDrawerAccNo());
        cltTrsDetailEdcInpDto.put("ccyNbr", (Object)"10");
        cltTrsDetailEdcInpDto.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        cltTrsDetailEdcInpDto.put("bchCnt", (Object)"1");
        cltTrsDetailEdcInpDto.put("bchTyp", (Object)"OPR");
        String flwCod = BankBusinessConfig.getBusMod(receivableInfos[0].getDrawerAccNo());
        if (StringUtils.isEmpty((String)flwCod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u8d26\u6237\u9644\u52a0\u5c5e\u6027\u9875\u9762\u7ef4\u62a4\u3002", (String)"PaymentNoteReceivableImpl_3", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        cltTrsDetailEdcInpDto.put("flwCod", (Object)flwCod);
        array2.add((Object)cltTrsDetailEdcInpDto);
        body.put("batchBusOprX1", (Object)array2);
        JSONObject sceneDataMap2 = new JSONObject();
        JSONArray array6 = new JSONArray();
        JSONObject busOprIpt = new JSONObject();
        JSONObject busOprIptDetail = new JSONObject();
        busOprIptDetail.put("cnlRef", (Object)SaasUtil.getRnlRef(receivableInfos[0].getBankBatchSeqId()));
        busOprIptDetail.put("flwTyp", (Object)"ND0010");
        busOprIptDetail.put("busTyp", (Object)"PB");
        busOprIptDetail.put("busSty", (Object)"03");
        busOprIptDetail.put("busTrs", (Object)type);
        busOprIptDetail.put("busStr", (Object)receivableInfos[0].getDraftType());
        busOprIptDetail.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        busOprIptDetail.put("ccyNbr", (Object)"10");
        busOprIptDetail.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        busOprIptDetail.put("bchCnt", (Object)"1");
        busOprIptDetail.put("bchTyp", (Object)"OPR");
        busOprIpt.put("busOprIpt", (Object)busOprIptDetail);
        busOprIpt.put("sceneDataMap", (Object)sceneDataMap2);
        array6.add((Object)busOprIpt);
        body.put("batchDetail", (Object)array6);
        JSONArray array7 = new JSONArray();
        JSONObject sceneDataMap = new JSONObject();
        array7.add((Object)sceneDataMap);
        sceneDataMap2.put("BusinessCancelApplyX1", (Object)array7);
        sceneDataMap.put("appBrd", (Object)receivableInfos[0].getDrawerBankCnaps());
        sceneDataMap.put("appEac", (Object)receivableInfos[0].getDrawerAccNo());
        sceneDataMap.put("appSrc", (Object)"CS02");
        sceneDataMap.put("busCnl", (Object)"EDC");
        JSONArray array8 = new JSONArray();
        JSONObject BusinessCancelApplyX2 = new JSONObject();
        array8.add((Object)BusinessCancelApplyX2);
        sceneDataMap2.put("BusinessCancelApplyX2", (Object)array8);
        BusinessCancelApplyX2.put("orgBus", flag.get("busSeq"));
        BusinessCancelApplyX2.put("innNbr", flag.get("innNbr"));
        BusinessCancelApplyX2.put("bilNbr", (Object)receivableInfos[0].getBillNo());
        BusinessCancelApplyX2.put("busCod", flag.get("busCod"));
        BusinessCancelApplyX2.put("cltRef", (Object)receivableInfos[0].getBankBatchSeqId());
        JSONObject head = JsonUtil.getHead("combuscancel", Sequence.genSequence());
        JSONObject result = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(result, this.logger, "combuscancel");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String rsp) {
        ParserReceivable.parsePay(request.getNoteReceivableInfos(), rsp);
        return request.getNoteReceivableInfos();
    }
}

