/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.receivable.pledge;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.receivable.pledge.QueryPledgeNoteReceivableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.util.AvaiableQuery;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.ParserReceivable;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SaasUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class PledgeNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PledgeNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPledgeNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "presentation";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d28\u62bc", (String)"PledgeNoteReceivableImpl_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        String rqstStr = this.pack(request, null);
        String rspStr = PostUtil.sendMsgForPay(rqstStr);
        try {
            List<NoteReceivableInfo> infos = this.parse(request, rspStr);
            return new EBBankNoteReceivableResponse(infos);
        }
        catch (Exception e) {
            this.logger.error("error ", (Throwable)e);
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankNoteReceivableResponse(request.getNoteReceivableInfos());
        }
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        BankAcnt acnt = request.getAcnt();
        NoteReceivableInfo[] receivableInfos = request.getNotePayableInfosAsArray();
        AvaiableQuery avaiable = new AvaiableQuery();
        String startNo = receivableInfos[0].getStartNo();
        String endNo = receivableInfos[0].getEndNo();
        Map flag = avaiable.getmsg(receivableInfos[0].getDrawerAccNo(), "BC11", receivableInfos[0].getBillNo(), receivableInfos[0].getStartNo(), receivableInfos[0].getEndNo());
        if (flag == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6b64\u7968\u636e\u4e0d\u80fd\u8d28\u62bc", (String)"PledgeNoteReceivableImpl_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        JSONObject body = new JSONObject();
        JSONArray array1 = new JSONArray();
        JSONObject qryHdr = new JSONObject();
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            qryHdr.put("cltNbr", (Object)cltNbr);
        } else {
            qryHdr.put("cltNbr", (Object)acnt.getAccNo().substring(0, 10));
        }
        array1.add((Object)qryHdr);
        body.put("trxHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject cltTrsDetailEdcInpDto = new JSONObject();
        cltTrsDetailEdcInpDto.put("cnlRef", (Object)SaasUtil.getRnlRef(receivableInfos[0].getBankBatchSeqId()));
        cltTrsDetailEdcInpDto.put("flwTyp", (Object)"ND0010");
        String flwCod = BankBusinessConfig.getBusMod(receivableInfos[0].getDrawerAccNo());
        if (StringUtils.isEmpty((String)flwCod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u8d26\u6237\u9644\u52a0\u5c5e\u6027\u9875\u9762\u7ef4\u62a4\u3002", (String)"PaymentNoteReceivableImpl_3", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        cltTrsDetailEdcInpDto.put("flwCod", (Object)flwCod);
        cltTrsDetailEdcInpDto.put("busTyp", (Object)"DB");
        cltTrsDetailEdcInpDto.put("busSty", (Object)"07");
        cltTrsDetailEdcInpDto.put("busTrs", (Object)"OUT");
        cltTrsDetailEdcInpDto.put("busStr", (Object)receivableInfos[0].getDraftType());
        cltTrsDetailEdcInpDto.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        cltTrsDetailEdcInpDto.put("sndEac", (Object)receivableInfos[0].getDrawerAccNo());
        cltTrsDetailEdcInpDto.put("ccyNbr", (Object)"10");
        cltTrsDetailEdcInpDto.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        cltTrsDetailEdcInpDto.put("bchCnt", (Object)"1");
        cltTrsDetailEdcInpDto.put("bchTyp", (Object)"OPR");
        cltTrsDetailEdcInpDto.put("trsAmt", (Object)receivableInfos[0].getAmount().toString());
        array2.add((Object)cltTrsDetailEdcInpDto);
        body.put("batchBusOprX1", (Object)array2);
        JSONArray array6 = new JSONArray();
        JSONObject busOprIpt = new JSONObject();
        busOprIpt.put("busOprIpt", (Object)cltTrsDetailEdcInpDto);
        array6.add((Object)busOprIpt);
        body.put("batchDetail", (Object)array6);
        JSONArray array7 = new JSONArray();
        JSONObject sceneDataMap = new JSONObject();
        array7.add((Object)sceneDataMap);
        JSONObject PresentationApplyX2 = new JSONObject();
        PresentationApplyX2.put("CollateralApplyX2", (Object)array7);
        busOprIpt.put("sceneDataMap", (Object)PresentationApplyX2);
        sceneDataMap.put("bilNbr", (Object)receivableInfos[0].getBillNo());
        sceneDataMap.put("bilSbs", (Object)startNo);
        sceneDataMap.put("bilSbe", (Object)endNo);
        sceneDataMap.put("subAmt", (Object)receivableInfos[0].getAmount().toString());
        sceneDataMap.put("cltRef", (Object)receivableInfos[0].getBankBatchSeqId());
        JSONArray array8 = new JSONArray();
        JSONObject ComReplyBchX1 = new JSONObject();
        array8.add((Object)ComReplyBchX1);
        ComReplyBchX1.put("appEac", (Object)acnt.getAccNo());
        ComReplyBchX1.put("opcNam", (Object)receivableInfos[0].getPayeeAccName());
        ComReplyBchX1.put("opcBrd", (Object)receivableInfos[0].getPayeeBankCnaps());
        ComReplyBchX1.put("opcEac", (Object)receivableInfos[0].getPayeeAccNo());
        ComReplyBchX1.put("appSrc", (Object)"CS02");
        ComReplyBchX1.put("busCod", (Object)"BC11");
        ComReplyBchX1.put("busDat", (Object)DateUtil.formatDate((Date)new Date()));
        ComReplyBchX1.put("busCnl", (Object)"EDC");
        ComReplyBchX1.put("prxApp", (Object)"PS01");
        ComReplyBchX1.put("busCcy", (Object)"10");
        ComReplyBchX1.put("busAmt", (Object)receivableInfos[0].getAmount().toString());
        ComReplyBchX1.put("accEac", (Object)acnt.getAccNo());
        ComReplyBchX1.put("busCnt", (Object)"1");
        body.put("CollateralApplyX1", (Object)array8);
        JSONObject head = JsonUtil.getHead("collateral", Sequence.genSequence());
        JSONObject result = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(result, this.logger, "collateral");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        ParserReceivable.parsePay(request.getNoteReceivableInfos(), responseStr);
        return request.getNoteReceivableInfos();
    }
}

