/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.payable;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.util.Check;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryResultUtil {
    public static String packerPayable(NotePayableInfo[] infos) {
        Element root = new Element("body");
        if (StringUtils.isEmpty((String)infos[0].getRspserialno())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u7ed3\u679c", (String)"QueryResultUtil_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID(infos[0].getDrawerAccNo()));
        JDomUtils.addChild((Element)root, (String)"eBillBatchNo", (String)infos[0].getRspserialno());
        JDomUtils.addChild((Element)root, (String)"beginNumber", (String)"1");
        JDomUtils.addChild((Element)root, (String)"queryNumber", (String)"20");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("PJ28", signedMsg);
    }

    public static void parserPayable(List<NotePayableInfo> infos, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        String code = rsp.getResponseCode();
        if (!"AAAAAAA".equals(code)) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(rspStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            Element lists = Check.checkNoNullChildElement(body, "lists");
            List localList = lists.getChildren("list");
            for (Element element : localList) {
                String eBillStatus = element.getChildTextTrim("eBillStatus");
                String billCirulateFlag = element.getChildTextTrim("billCirulateFlag");
                infos.get(0).setNoteStatus(eBillStatus);
                infos.get(0).setCirStatus(billCirulateFlag);
                String pcsStatusMsg = element.getChildTextTrim("pcsStatusMsg");
                String failReason = element.getChildTextTrim("failReason");
                String businessSeqNo = element.getChildTextTrim("businessSeqNo");
                infos.get(0).setBankRefKey(businessSeqNo);
                String status = element.getChildTextTrim("status");
                if ("03".equals(pcsStatusMsg) && "07".equals(status)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)infos.get(0), (PaymentState)PaymentState.SUCCESS, (String)pcsStatusMsg, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryResultUtil_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                } else if ("05".equals(pcsStatusMsg) && "07".equals(status)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)infos.get(0), (PaymentState)PaymentState.SUCCESS, (String)pcsStatusMsg, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryResultUtil_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                } else if ("04".equals(pcsStatusMsg) || "07".equals(pcsStatusMsg) || "08".equals(pcsStatusMsg) || "09".equals(pcsStatusMsg)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)infos.get(0), (PaymentState)PaymentState.FAIL, (String)pcsStatusMsg, (String)failReason);
                } else if ("06".equals(pcsStatusMsg)) {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)infos.get(0), (PaymentState)PaymentState.FAIL, (String)pcsStatusMsg, (String)ResManager.loadKDString((String)"\u5bf9\u65b9\u62d2\u7edd\u7b7e\u6536", (String)"QueryResultUtil_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                } else {
                    EBGNotePayableUtils.setPaymentState((NotePayableInfo)infos.get(0), (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryResultUtil_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                }
                if (!"remit_register".equals(infos.get(0).getSubBizType())) continue;
                String billPackageNo = element.getChildTextTrim("billPackageNo");
                String sonBillRngLow = element.getChildTextTrim("sonBillRngLow");
                String sonBillRngHight = element.getChildTextTrim("sonBillRngHight");
                infos.get(0).setBillNo(billPackageNo);
                infos.get(0).setStartNo(sonBillRngLow);
                infos.get(0).setEndNo(sonBillRngHight);
            }
        }
    }

    public static void parserCommon(List<NotePayableInfo> infos, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = Parser.parseResponse(root);
        String code = rsp.getResponseCode();
        if ("EYY8997".equals(code)) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)code, (String)rsp.getResponseMessage());
        } else if (!"AAAAAAA".equals(code)) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)code, (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(rspStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String eBillBatchNo = body.getChildTextTrim("eBillBatchNo");
            infos.get(0).setRspserialno(eBillBatchNo);
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u4f01\u6210\u529f", (String)"QueryResultUtil_4", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
        }
    }
}

