/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.codeless.receivable.cancle;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.QueryReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.codeless.receivable.QueryResultUtil;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CodelessCancleReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryReceivableImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "PJ05";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u64a4\u9500", (String)"CodelessCancleReceivableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest request, String s) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        Element root = new Element("body");
        JDomUtils.addChild((Element)root, (String)"totalNumber", (String)(infos.length + ""));
        JDomUtils.addChild((Element)root, (String)"totalAmount", (String)request.getTotalAmount().toPlainString());
        JDomUtils.addChild((Element)root, (String)"transMasterID", (String)BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo()));
        JDomUtils.addChild((Element)root, (String)"eDrawerAcctName", (String)infos[0].getDrawerAccName());
        JDomUtils.addChild((Element)root, (String)"eBillType", (String)infos[0].getDraftType());
        JDomUtils.addChild((Element)root, (String)"acctNo", (String)infos[0].getDrawerAccNo());
        JDomUtils.addChild((Element)root, (String)"eBillingType", (String)"01");
        JDomUtils.addChild((Element)root, (String)"eBillingType", (String)"01");
        Element lists = new Element("lists");
        lists.setAttribute("name", "edraftList");
        JDomUtils.addChild((Element)root, (Element)lists);
        for (int i = 0; i < infos.length; ++i) {
            Element list = new Element("list");
            JDomUtils.addChild((Element)lists, (Element)list);
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)"0001");
            JDomUtils.addChild((Element)list, (String)"billPackageNo", (String)infos[i].getBillNo());
            String startNo = infos[i].getStartNo();
            String endNo = infos[i].getEndNo();
            JDomUtils.addChild((Element)list, (String)"sonBillRngLow", (String)startNo);
            JDomUtils.addChild((Element)list, (String)"sonBillRngHight", (String)endNo);
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)infos[i].getAmount().toString());
            JDomUtils.addChild((Element)list, (String)"jnlSeqnoID", (String)infos[i].getBankRefKey());
        }
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("PJ05", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String rspStr) {
        List infos = request.getNoteReceivableInfos();
        QueryResultUtil.parserCommon(infos, rspStr);
        return infos;
    }
}

