/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.payable.accept;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryAcceptNotePayableImpl
extends AbstractQueryNotePayableImpl {
    public String pack(BankNotePayableRequest request, String pageTag) {
        List notePayablenotePayable = request.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)notePayablenotePayable.get(0);
        int length = notePayablenotePayable.size();
        String eBillBatchNo = info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + info.getObssid();
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"eBillBatchNo", (String)eBillBatchNo);
        JDomUtils.addChild((Element)body, (String)"businessType");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)"   1");
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"  20");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE28", signedMsg);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        List notePayable = request.getNotePayableInfoList();
        NotePayableInfo payableInfo = (NotePayableInfo)notePayable.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
            Element dtlListElement = body.getChild("lists");
            List dtlLists = dtlListElement.getChildren("list");
            for (Element p : dtlLists) {
                String status;
                int index = dtlLists.indexOf(p);
                switch (status = p.getChildText("status")) {
                    case "00": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u5904\u7406", (String)"QueryAcceptNotePayableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "01": {
                        String eBillStatus = ParserUtils.checkUnNullableElement((Element)p, (String)"eBillStatus");
                        String billNo = p.getChildText("billNo");
                        String transJnlNo = p.getChildText("transJnlNo");
                        payableInfo = (NotePayableInfo)notePayable.get(index);
                        payableInfo.setBillNo(billNo);
                        payableInfo.setReserved1(transJnlNo);
                        payableInfo.setNoteStatus(eBillStatus);
                        if (eBillStatus.equals("020001")) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u8bf7\u7b49\u5f85\u7b7e\u6536\u6210\u529f\u540e\u518d\u8fdb\u884c\u540c\u6b65\u3002", (String)"QueryAcceptNotePayableImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                            break;
                        }
                        if (eBillStatus.equals("020006")) {
                            EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUCCESS, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5904\u7406\u6210\u529f", (String)"QueryAcceptNotePayableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                            break;
                        }
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryAcceptNotePayableImpl_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "02": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"QueryAcceptNotePayableImpl_4", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "03": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5df2\u53d1\u9001", (String)"QueryAcceptNotePayableImpl_5", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "04": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"QueryAcceptNotePayableImpl_6", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "05": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5ba1\u6838\u4e2d", (String)"QueryAcceptNotePayableImpl_7", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    case "06": {
                        EBGNotePayableUtils.setPaymentState((NotePayableInfo)payableInfo, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"QueryAcceptNotePayableImpl_8", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                    }
                }
            }
        }
        return notePayable;
    }

    public int getBatchSize() {
        return 20;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u627f\u5151\u540c\u6b65", (String)"QueryAcceptNotePayableImpl_9", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }
}

