/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.receivable.cancle;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.note.receivable.cancle.QueryCancleNoteReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class CancleNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryCancleNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        int length = noteReceivableInfos.size();
        BigDecimal totalAmout = BigDecimal.ZERO;
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"eBillBatchNo");
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)(length + ""));
        JDomUtils.addChild((Element)body, (String)"totalAmount");
        Element cycle = Packer.creatCycleMessage();
        JDomUtils.addChild((Element)body, (Element)cycle);
        for (NoteReceivableInfo p : noteReceivableInfos) {
            Element list = JDomUtils.addChild((Element)cycle, (String)"list");
            BigDecimal temp = p.getAmount();
            totalAmout = totalAmout.add(temp);
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)String.format("%04d", noteReceivableInfos.indexOf(p)));
            JDomUtils.addChild((Element)list, (String)"jnlSeqnoID", (String)p.getReserved1());
            JDomUtils.addChild((Element)list, (String)"eDrawerNo", (String)p.getBillNo());
            JDomUtils.addChild((Element)list, (String)"eBillAmount", (String)temp.toPlainString());
            JDomUtils.addChild((Element)list, (String)"oldTransDate", (String)p.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)list, (String)"oldTransJnlNo", (String)p.getBankRefKey());
        }
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("FE05", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List infos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (rsp.getResponseCode().startsWith("EYY")) {
            Element body = root.getChild("body");
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
            return infos;
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
        if ("AAAAAAA".equals(rsp.getResponseCode())) {
            String businessId = body.getChildText("businessId");
            if (StringUtils.isEmpty((String)businessId)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u64a4\u9500\u64cd\u4f5c\u94f6\u884c\u672a\u8fd4\u56debusinessId,\u94f6\u4f01\u7968\u636e\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed", (String)"CancleNoteReceivableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                ((NoteReceivableInfo)infos.get(0)).setBankRefKey(businessId);
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CancleNoteReceivableImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            }
        } else {
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
        }
        return infos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u9500", (String)"CancleNoteReceivableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

