/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.receivable.discount;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryDiscountNoteReceivableImpl
extends AbstractQueryNoteReceivableImpl {
    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String eBillBatchNo = info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + info.getBankRefKey();
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"eBillBatchNo", (String)eBillBatchNo);
        JDomUtils.addChild((Element)body, (String)"businessType");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)"   1");
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"  20");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE28", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (!"AAAAAAA".equals(rsp.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
            Element dtlListElement = body.getChild("lists");
            List dtlLists = dtlListElement.getChildren("list");
            Element rs = (Element)dtlLists.get(0);
            String status = rs.getChildText("status");
            String billNo = ParserUtils.checkUnNullableElement((Element)rs, (String)"billNo");
            String transJnlNo = rs.getChildText("transJnlNo");
            String eBillStatus = ParserUtils.checkUnNullableElement((Element)rs, (String)"eBillStatus");
            if (eBillStatus.equals("030006")) {
                info.setNoteStatus("110101");
            } else {
                info.setNoteStatus(eBillStatus);
            }
            info.setBillNo(billNo);
            info.setReserved1(transJnlNo);
            switch (status) {
                case "00": {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u5904\u7406", (String)"QueryDiscountNoteReceivableImpl_0", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                    break;
                }
                case "01": {
                    if (eBillStatus.equals("110106")) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"QueryDiscountNoteReceivableImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                        break;
                    }
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u540c\u6b65", (String)"QueryDiscountNoteReceivableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                    break;
                }
                case "02": {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"QueryDiscountNoteReceivableImpl_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                    break;
                }
                case "03": {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5df2\u53d1\u9001", (String)"QueryDiscountNoteReceivableImpl_4", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                    break;
                }
                case "04": {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"QueryDiscountNoteReceivableImpl_5", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                    break;
                }
                case "05": {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5ba1\u6838\u4e2d", (String)"QueryDiscountNoteReceivableImpl_6", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                    break;
                }
                case "06": {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u88ab\u94f6\u884c\u62d2\u7edd", (String)"QueryDiscountNoteReceivableImpl_7", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
                }
            }
        }
        return receivableInfos;
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }
}

