/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.receivable.signin;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.note.receivable.signin.QuerySigninNoteReceivableImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class SigninNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(SigninNoteReceivableImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QuerySigninNoteReceivableImpl.class;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        String transtype = null;
        String code = info.getOperationCode();
        if ("03".equals(code)) {
            transtype = "03";
        } else if ("10".equals(code)) {
            transtype = "05";
        } else if ("20".equals(code)) {
            transtype = "17";
        } else if ("02".equals(code)) {
            transtype = "02";
        } else if ("11".equals(code)) {
            transtype = "06";
        } else if ("18".equals(code)) {
            transtype = "15";
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7b7e\u6536\u7c7b\u578b\uff1a%s\u3002", (String)"SigninNoteReceivableImpl_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]), code));
        }
        Element body = new Element("body");
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        String eBillBusinessId = info.getBankRefKey();
        String accept = info.getOtherInfo();
        this.logger.info("\u7b7e\u6536\u7ed3\u679c\u4e3a\uff1a" + accept);
        this.logger.info("\u4eceEE25\u83b7\u53d6\u5230\u7684eBillBusinessId\u4e3a:" + eBillBusinessId);
        JDomUtils.addChild((Element)body, (String)"eBillBusinessId", (String)eBillBusinessId);
        JDomUtils.addChild((Element)body, (String)"eBillBusinessType", (String)transtype);
        JDomUtils.addChild((Element)body, (String)"billNo", (String)info.getBillNo());
        JDomUtils.addChild((Element)body, (String)"unconditionalPayConsign", (String)"CC00");
        JDomUtils.addChild((Element)body, (String)"eBillAmount", (String)info.getAmount().toPlainString());
        JDomUtils.addChild((Element)body, (String)"signDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"signResult", (String)accept);
        JDomUtils.addChild((Element)body, (String)"signerType", (String)"RC01");
        JDomUtils.addChild((Element)body, (String)"signerName", (String)info.getDrawerAccName());
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)body, (String)"signerLevel");
        JDomUtils.addChild((Element)body, (String)"signerRateOrg");
        JDomUtils.addChild((Element)body, (String)"signerRateDate");
        JDomUtils.addChild((Element)body, (String)"signerAddress");
        if (accept.equals("SU01")) {
            JDomUtils.addChild((Element)body, (String)"noPayReason", (String)info.getReserved2());
            if (info.getReserved2().equals("10")) {
                JDomUtils.addChild((Element)body, (String)"noPayRemark", (String)info.getReserved3());
            } else {
                JDomUtils.addChild((Element)body, (String)"noPayRemark");
            }
        } else {
            JDomUtils.addChild((Element)body, (String)"noPayReason");
        }
        JDomUtils.addChild((Element)body, (String)"remark");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE06", signedMsg);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List infos = request.getNoteReceivableInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (rsp.getResponseCode().startsWith("EYY")) {
            Element body = root.getChild("body");
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
            return infos;
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
        if ("AAAAAAA".equals(rsp.getResponseCode())) {
            String businessId = body.getChildText("businessId");
            this.logger.info("\u7b7e\u6536\u4e1a\u52a1\u94f6\u884c\u8fd4\u56de\u7684businessID\u4e3a\uff1a" + businessId);
            if (StringUtils.isEmpty((String)businessId)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u65b0\u589e\u7968\u636e\u94f6\u884c\u672a\u8fd4\u56debusinessId,\u94f6\u4f01\u7968\u636e\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed", (String)"SigninNoteReceivableImpl_1", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                ((NoteReceivableInfo)infos.get(0)).setBankRefKey(businessId);
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SigninNoteReceivableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            }
        } else if ("EYY8804".equals(rsp.getResponseCode())) {
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)message);
        } else {
            String message = body.getChildTextTrim("returnMsg");
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
        }
        return infos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

