/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzrcb.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        String bankLogin = request.getBankLoginId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        boolean isLastFile = false;
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail downloadListDetail;
            boolean flag;
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            if (!(flag = this.download(downloadListDetail = (DownloadListDetail)downloadListDetails.get(i), bakFilePath, bankLogin, isLastFile, sftp, bankFtpProperties))) continue;
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u56de\u5355\u6587\u4ef6\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-gzrcb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String destFolder, String bankLogin, boolean isLastFile, ChannelSftp sftp, BankFtpProperties bankFtpProperties) {
        File file;
        String accNo = detail.getAccNo();
        LocalDate transDate = detail.getTransDate();
        String sftp_path = bankFtpProperties.getFtpPath();
        sftp_path = StringUtils.isEmpty((String)sftp_path) ? "/" : sftp_path;
        String newFileName = detail.getFileName();
        File receiptFile = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + detail.getFileName()));
        if (receiptFile.exists()) {
            return true;
        }
        boolean result = false;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLogin);
            }
            result = SFTPUtils.getInstance().downloadSingleFile(sftp_path, detail.getFileLink(), destFolder, sftp);
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            String receiptPath = bankFtpProperties.getFrontProxyPath();
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
            result = bankReceiptApiUtil.downloadReceiptFileWithPath(receiptPath, detail.getFileLink(), destFolder);
        }
        if ((file = FileCommonUtils.getFileByPath((String)(destFolder + File.separator + detail.getFileLink()))).exists()) {
            FileCommonUtils.moveFile((File)file, (String)destFolder, (String)newFileName);
            boolean isDelete = file.delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}\uff0c\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{detail.getFileLink(), isDelete});
        } else {
            result = false;
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GZRCB_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e7f\u5dde\u519c\u5546\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-gzrcb-dc", (Object[])new Object[0]);
    }
}

