/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzrcb.dc.service.receipt.api;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gzrcb.dc.service.receipt.utils.RequestPacker;
import kd.ebg.receipt.banks.gzrcb.dc.service.receipt.utils.ResponseParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class BankTransDetailQueryImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankTransDetailQueryImpl.class);

    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        Map paramsMap = request.getParamsMap();
        String userId = (String)paramsMap.get("userId");
        String detailRequest = RequestPacker.receiptDetail(accNo, transDateStr, userId);
        logger.info("\u5e7f\u5dde\u519c\u5546\u94f6\u884c\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u2014\u2014\u8bf7\u6c42\uff1a{}", (Object)detailRequest);
        return detailRequest;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        logger.info("\u5e7f\u5dde\u519c\u5546\u94f6\u884c\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u2014\u2014\u54cd\u5e94\uff1a{}", (Object)responseStr);
        List<Map<String, String>> list = ResponseParser.detailParser(responseStr);
        return BankReceiptResponseEB.success(list);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "GZRCB_DC_TRADE_DETAIL_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e7f\u5dde\u519c\u5546\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8bf7\u6c42\u3002", (String)"BankTransDetailQueryImpl_0", (String)"ebg-receipt-banks-gzrcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
    }
}

