/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzrcb.dc.service.receipt.utils;

import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class RequestPacker {
    public static String receiptDetail(String acNo, String transDate, String userId) {
        Element msg = JDomExtUtils.createRoot((String)"msg");
        JDomUtils.addChild((Element)msg, (Element)RequestPacker.headPack());
        Element main_data = JDomUtils.addChild((Element)msg, (String)"main_data");
        JDomUtils.addChild((Element)main_data, (String)"USERID", (String)userId);
        JDomUtils.addChild((Element)main_data, (String)"KEHUZH", (String)acNo);
        JDomUtils.addChild((Element)main_data, (String)"ZHZTMS", (String)"0001");
        JDomUtils.addChild((Element)main_data, (String)"HUOBDH", (String)"01");
        JDomUtils.addChild((Element)main_data, (String)"QISHRQ", (String)transDate);
        JDomUtils.addChild((Element)main_data, (String)"DAOQRQ", (String)transDate);
        JDomUtils.addChild((Element)main_data, (String)"QISHBS", (String)"0000");
        JDomUtils.addChild((Element)main_data, (String)"CXUNBS", (String)"9999");
        String request = JDomUtils.doc2StrUTF8((Document)new Document(msg));
        return RequestPacker.requestHead(request, "YQ005") + request;
    }

    public static String receiptDownload(String acNo, String transDate, String sernum, String userId) {
        Element msg = JDomExtUtils.createRoot((String)"msg");
        JDomUtils.addChild((Element)msg, (Element)RequestPacker.headPack());
        Element main_data = JDomUtils.addChild((Element)msg, (String)"main_data");
        JDomUtils.addChild((Element)main_data, (String)"USERID", (String)userId);
        JDomUtils.addChild((Element)main_data, (String)"ACNO", (String)acNo);
        JDomUtils.addChild((Element)main_data, (String)"CUR_CODE", (String)"01");
        JDomUtils.addChild((Element)main_data, (String)"TR_DATE", (String)transDate);
        JDomUtils.addChild((Element)main_data, (String)"SERIAL_NO", (String)sernum);
        JDomUtils.addChild((Element)main_data, (String)"SPECIES", (String)"1");
        String request = JDomUtils.doc2StrUTF8((Document)new Document(msg));
        return RequestPacker.requestHead(request, "YQ401") + request;
    }

    public static Element headPack() {
        String chnl_seq = Sequence.gen18Sequence();
        chnl_seq = chnl_seq.substring(chnl_seq.length() - 12);
        String LocalDate2 = LocalDateTime.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        String LocalTime2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHssmm"));
        Element comm_head = new Element("comm_head");
        JDomExtUtils.addChild((Element)comm_head, (String)"ver_no", (String)"1.0");
        JDomExtUtils.addChild((Element)comm_head, (String)"reserve", (String)"");
        JDomExtUtils.addChild((Element)comm_head, (String)"reserve1", (String)"");
        JDomExtUtils.addChild((Element)comm_head, (String)"reserve2", (String)"");
        JDomExtUtils.addChild((Element)comm_head, (String)"ext_txn_no", (String)"");
        JDomExtUtils.addChild((Element)comm_head, (String)"chnl_dt", (String)LocalDate2);
        JDomExtUtils.addChild((Element)comm_head, (String)"host_dt", (String)LocalDate2);
        JDomExtUtils.addChild((Element)comm_head, (String)"chnl_tm", (String)LocalTime2);
        JDomExtUtils.addChild((Element)comm_head, (String)"host_tm", (String)LocalTime2);
        JDomExtUtils.addChild((Element)comm_head, (String)"chnl_seq", (String)chnl_seq);
        JDomExtUtils.addChild((Element)comm_head, (String)"host_seq", (String)"");
        JDomExtUtils.addChild((Element)comm_head, (String)"rsp_no", (String)"");
        JDomExtUtils.addChild((Element)comm_head, (String)"rsp_msg", (String)"");
        return comm_head;
    }

    public static String requestHead(String request, String transCode) {
        String requestHeadLength = String.valueOf(request.length() + 31);
        try {
            requestHeadLength = StringFormater.formatLen((String)requestHeadLength, (int)6, (boolean)true, (char)'0', (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return requestHeadLength + transCode + "000000000000000AAAA#";
    }
}

