/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.jsb.cmp.service.receipt;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.receipt.banks.jsb.cmp.service.receipt.api.BankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        long taskId = request.getTaskId();
        String customId = EBContext.getContext().getCustomID();
        Object sftp = null;
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        String sftp_path = ftpProperties.getFtpPath();
        sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
        String frontProxyPath = ftpProperties.getFrontProxyPath();
        IParameter parameter = EBContext.getContext().getParameter();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String date = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        String filename = this.sendAndReceiveReceipt(accNo, transDate);
        if (filename == null || "".equals(filename)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-jsb-cmp", (Object[])new Object[0]));
        }
        DownloadListDetail downloadListDetail = new DownloadListDetail();
        downloadListDetail.setFileName(filename);
        downloadListDetail.setFileLink(filename);
        result.add(downloadListDetail);
        RequestContextUtils.setZipName((String)filename);
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-jsb-cmp", (Object[])new Object[0]));
        }
        logger.info(">>>>>>>>>\u6c5f\u82cf\u94f6\u884c-FETCH-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, result.size()});
        return BankReceiptHandleResponseEB.success(result);
    }

    private String sendAndReceiveReceipt(String accNo, LocalDate localDate) {
        BankReceiptRequest request = BankReceiptRequest.builder().accNo(accNo).transDate(localDate).build();
        BankReceiptImpl bankReceipt = new BankReceiptImpl();
        BankReceiptResponseEB bankReceiptResponseEB = (BankReceiptResponseEB)bankReceipt.doBiz((BankRequest)request);
        return (String)bankReceiptResponseEB.getData();
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "JSB_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-jsb-cmp", (Object[])new Object[0]);
    }
}

