/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.pab.dc.service.receipt.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class SocletUtils {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(SocletUtils.class);
    private static String host = null;
    private static int port = 0;

    public static String sendRequest(String request, String bankLogin) {
        StringBuilder response = new StringBuilder();
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String exchangePort = RequestContextUtils.getBankParameterValue((String)"exchangePort");
        if (EBGStringUtils.isNotEmpty((String)ip)) {
            host = ip;
            port = Integer.parseInt(exchangePort);
        } else {
            BankLoginProperties loginProperties = (BankLoginProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginProperties.class, bankLogin);
            host = loginProperties.getIp();
            port = loginProperties.getPort();
        }
        try (Socket socket = new Socket(host, port);){
            socket.setSoTimeout(180000);
            try (OutputStream os = socket.getOutputStream();
                 PrintWriter pw = new PrintWriter(os);){
                pw.write(request);
                pw.flush();
                try (InputStream is = socket.getInputStream();
                     BufferedReader br = new BufferedReader(new InputStreamReader(is, "GBK"));){
                    String info = null;
                    while ((info = br.readLine()) != null) {
                        response.append(info);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex.fillInStackTrace());
            String msg = ErrorMsgUtil.getLinkErrorMSG((String)ex.getMessage());
            throw new ReceiptException(msg, (Throwable)ex);
        }
        return response.toString();
    }
}

