/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.cmp.service.receipt;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.icbc.cmp.service.detail.SeniorDetailImpl;
import kd.ebg.receipt.banks.icbc.cmp.service.receipt.ICBC_CMP_Packer;
import kd.ebg.receipt.banks.icbc.cmp.service.receipt.ICBC_CMP_Parser;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.detail.utils.DetailSysFiled;
import kd.ebg.receipt.business.receipt.atom.AbstractReceiptImpl;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankLoginReceiptProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.framework.utils.ParserUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class ICBCCMPReceiptImpl
extends AbstractReceiptImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBCCMPReceiptImpl.class);

    public ReceiptResponseEB queryReceipt(ReceiptRequest request) {
        SeniorDetailImpl impl = new SeniorDetailImpl();
        BankAcnt bankAcnt = EBContext.getContext().getBankAcnt();
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        String bankCurrency = request.getHeader().getBankCurrency();
        BankDetailRequest bankDetailRequest = new BankDetailRequest();
        bankDetailRequest.setHeader(request.getHeader());
        bankDetailRequest.setBankCurrency(bankCurrency);
        bankDetailRequest.setStartDate(startDate);
        bankDetailRequest.setEndDate(endDate);
        logger.info("\u5de5\u884c\u62a5\u6587\u7535\u5b50\u56de\u5355\u4e0b\u8f7d-\u8d26\u53f7=" + bankAcnt + " \u8d77\u59cb\u65e5\u671f=" + startDate + " \u622a\u6b62\u65e5\u671f=" + endDate + " \u5e01\u79cd=" + bankCurrency);
        EBBankDetailResponse detailResponse = impl.hisDetail(bankDetailRequest);
        List detailInfos = detailResponse.getDetails();
        String tInfoNew = null;
        ArrayList<ReceiptInfo> receiptInfos = new ArrayList<ReceiptInfo>();
        ReceiptResponseEB receiptResponse = new ReceiptResponseEB();
        if (detailInfos != null && detailInfos.size() > 0) {
            logger.info("\u5de5\u884c\u62a5\u6587\u7535\u5b50\u56de\u5355\u4e0b\u8f7d-\u8d26\u53f7\uff1a{}-\u5f00\u59cb\u65e5\u671f\uff1a{}-\u622a\u6b62\u65e5\u671f\uff1a{}-\u67e5\u8be2\u5230\u7684\u660e\u7ec6\u6570\u91cf\uff1a{}", new Object[]{bankAcnt.getAccNo(), startDate, endDate, detailInfos.size()});
            for (int i = 0; i < detailInfos.size(); ++i) {
                DetailInfo detailInfo = (DetailInfo)detailInfos.get(i);
                tInfoNew = DetailSysFiled.get((DetailInfo)detailInfo, (String)"TInfoNew");
                String AcctNo = bankAcnt.getAccNo();
                String CurrencyType = bankCurrency;
                String WorkDate = detailInfo.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                String detailNoString = detailInfo.getReceiptNo();
                String detailInfoJson = detailInfo.getJson();
                EBContext context = EBContext.getContext();
                IParameter parameter = context.getParameter();
                String signDate4Test = parameter.getBankParameter("signDate4Test");
                boolean isTest = EBGStringUtils.isNotEmpty((String)signDate4Test);
                String SignTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
                if (isTest) {
                    SignTime = signDate4Test + LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS"));
                }
                String paramsString = tInfoNew + "|" + AcctNo + "|" + SignTime + "|" + WorkDate + "|" + CurrencyType;
                ReceiptResponseEB response = this.sendAndRcvMsg(request, paramsString);
                logger.info("\u7535\u5b50\u56de\u5355\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u5b8c\u6210\n");
                int num = response.getReceiptInfos().size();
                logger.info("\u7535\u5b50\u56de\u5355\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u5bf9\u8c61\u4e2a\u6570\uff1a" + num + " \u4e2a\n");
                for (ReceiptInfo info : response.getReceiptInfos()) {
                    info.setReceiptNo(detailNoString);
                    info.setJson(detailInfoJson);
                    receiptInfos.add(info);
                    logger.info("\u67e5\u770b\u89e3\u6790\u7684\u6570\u636e\u7ed3\u679c\uff1a\n" + info.getAmount() + " " + info.getTransDate());
                }
            }
            receiptResponse.setFileFlag(0);
            receiptResponse.setReceiptInfos(receiptInfos);
            logger.info("\u7535\u5b50\u56de\u5355\u67e5\u8be2\u6210\u529f\n");
        }
        return receiptResponse;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    /*
     * Exception decompiling
     */
    private ReceiptResponseEB sendAndRcvMsg(ReceiptRequest request, String paramsString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean needLock() {
        return false;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return null;
    }

    public boolean match(ReceiptRequest request) {
        if (RequestContextUtils.receiptFormatIsFile()) {
            return false;
        }
        if (request.getHeader() != null) {
            String bankLoginId = request.getHeader().getBankLoginID();
            BankLoginReceiptProperties bankLoginReceiptProperties = (BankLoginReceiptProperties)EBConfigBuilder.getInstance().buildConfig(BankLoginReceiptProperties.class, bankLoginId);
            if (Objects.equals(bankLoginReceiptProperties.getIsNSyncDownloadReceipt(), "off")) {
                return true;
            }
            return Objects.equals(request.getHeader().getClientName(), "SYSTEM_RECEIPT_API");
        }
        return false;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u884c\u56de\u5355", (String)"ICBCCMPReceiptImpl_4", (String)"ebg-receipt-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public String pack(ReceiptRequest request) {
        return null;
    }

    public String pack(ReceiptRequest request, String params) {
        String AreaCode = "";
        String NetCode = "";
        String TellerNo = "";
        String TranSerialNo = "";
        String AcctNo = "";
        String SignTime = "";
        String WorkDate = "";
        String CurrencyType = "";
        String transCode = "DownEBill";
        String[] temp = params.split("\\|");
        if (temp.length == 8) {
            AreaCode = temp[0];
            NetCode = temp[1];
            TellerNo = temp[2];
            TranSerialNo = temp[3];
            AcctNo = temp[4];
            SignTime = temp[5];
            WorkDate = temp[6];
            CurrencyType = temp[7];
        }
        Element root = ICBC_CMP_Packer.createICBCCMPRoot(transCode);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"AreaCode", (String)AreaCode);
        JDomUtils.addChild((Element)in, (String)"NetCode", (String)NetCode);
        JDomUtils.addChild((Element)in, (String)"TellerNo", (String)TellerNo);
        JDomUtils.addChild((Element)in, (String)"WorkDate", (String)WorkDate);
        JDomUtils.addChild((Element)in, (String)"TranSerialNo", (String)TranSerialNo);
        JDomUtils.addChild((Element)in, (String)"AcctNo", (String)AcctNo);
        JDomUtils.addChild((Element)in, (String)"CurrencyType", (String)CurrencyType);
        JDomUtils.addChild((Element)in, (String)"SignTime", (String)SignTime);
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved3", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved4", (String)"");
        JDomUtils.addChild((Element)in, (String)"AcctSeq", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        logger.info("<\u7b7e\u540d\u524d>\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u62a5\u6587\uff1a\n" + reqstMsg);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHead(msgSigned, transCode, "0.0.1.0");
    }

    public ReceiptResponseEB parse(ReceiptRequest request, String responseStr) {
        ReceiptResponseEB receiptResponse = new ReceiptResponseEB();
        BankAcnt bankAcnt = EBContext.getContext().getBankAcnt();
        logger.info("\u7535\u5b50\u56de\u5355\u54cd\u5e94\u62a5\u6587\u89e3\u7801==================================>");
        String rspStrDecoded = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        logger.info("\u7535\u5b50\u56de\u5355\u54cd\u5e94\u62a5\u6587\u89e3\u7801\u5b8c\u6210==================================>\n");
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStrDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String retCodeString = JDomUtils.getChildElement((Element)pub, (String)"RetCode").getTextTrim();
        String retMsgString = JDomUtils.getChildElement((Element)pub, (String)"RetMsg").getTextTrim();
        if (!"0".equals(retCodeString)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u4e0b\u8f7d\u53d1\u751f\u5f02\u5e38 :%1$s-%2$s\u3002", (String)"ICBCCMPReceiptImpl_8", (String)"ebg-receipt-banks-icbc-cmp", (Object[])new Object[0]), retCodeString, retMsgString);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<ReceiptInfo> receiptInfoList = new ArrayList<ReceiptInfo>();
        ReceiptInfo receiptInfo = new ReceiptInfo();
        Element out = eb.getChild("out");
        if (out != null) {
            String ebillSerialno = JDomUtils.getChildElement((Element)out, (String)"EbillSerialno").getTextTrim();
            receiptInfo.setEbillSerialno(ebillSerialno);
            String payAccount = JDomUtils.getChildElement((Element)out, (String)"PayAccount").getTextTrim();
            receiptInfo.setAccNo(payAccount);
            String payAcctName = JDomUtils.getChildElement((Element)out, (String)"PayAcctName").getTextTrim();
            receiptInfo.setAccName(payAcctName);
            String payBankName = JDomUtils.getChildElement((Element)out, (String)"PayBankName").getTextTrim();
            receiptInfo.setBankName(payBankName);
            String recAccount = JDomUtils.getChildElement((Element)out, (String)"RecAccount").getTextTrim();
            receiptInfo.setOppAccNo(recAccount);
            String recAcctName = JDomUtils.getChildElement((Element)out, (String)"RecAcctName").getTextTrim();
            receiptInfo.setOppAccName(recAcctName);
            String recBankName = JDomUtils.getChildElement((Element)out, (String)"RecBankName").getTextTrim();
            receiptInfo.setOppBankName(recBankName);
            String payAmt = JDomUtils.getChildElement((Element)out, (String)"PayAmt").getTextTrim();
            try {
                BigDecimal payAmout = ParserUtils.convertCentStr2Yuan((String)payAmt);
                payAmt = payAmout.toString();
            }
            catch (Exception e) {
                payAmt = this.Transformation(payAmt);
            }
            receiptInfo.setAmount(payAmt);
            if (bankAcnt.getAccNo().equals(payAccount)) {
                receiptInfo.setDebitAmount(payAmt);
                receiptInfo.setCreditAmount("0");
            } else {
                receiptInfo.setDebitAmount("0");
                receiptInfo.setCreditAmount(payAmt);
            }
            String CurrType = JDomUtils.getChildElement((Element)out, (String)"CurrType").getTextTrim();
            CurrType = CurrencyUtils.convert2Iso((String)CurrType);
            receiptInfo.setCurrency(CurrType);
            String Summary = JDomUtils.getChildElement((Element)out, (String)"Summary").getTextTrim();
            receiptInfo.setExplanation(Summary);
            String BusType = JDomUtils.getChildElement((Element)out, (String)"BusType").getTextTrim();
            receiptInfo.setBusType(BusType);
            String UseCN = JDomUtils.getChildElement((Element)out, (String)"UseCN").getTextTrim();
            receiptInfo.setUseCn(UseCN);
            String TranSerialNo = JDomUtils.getChildElement((Element)out, (String)"TranSerialNo").getTextTrim();
            receiptInfo.setTranSerialNo(TranSerialNo);
            String TimeStamp = JDomUtils.getChildElement((Element)out, (String)"TimeStamp").getTextTrim();
            receiptInfo.setDetailDateTime(TimeStamp);
            String Remark = JDomUtils.getChildElement((Element)out, (String)"Remark").getTextTrim();
            receiptInfo.setRemark(Remark);
            String EbillKey = JDomUtils.getChildElement((Element)out, (String)"EbillKey").getTextTrim();
            receiptInfo.setEbillKey(EbillKey);
            receiptInfo.setValidateCode(EbillKey);
            String TransNetCode = JDomUtils.getChildElement((Element)out, (String)"TransNetCode").getTextTrim();
            receiptInfo.setTransNetCode(TransNetCode);
            String TransTellno = JDomUtils.getChildElement((Element)out, (String)"TransTellno").getTextTrim();
            receiptInfo.setTransTellno(TransTellno);
            String TransDate = JDomUtils.getChildElement((Element)out, (String)"TransDate").getTextTrim();
            String regex = "[\u4e00-\u9fa5]";
            Pattern pat = Pattern.compile(regex);
            Matcher mat = pat.matcher(TransDate);
            TransDate = mat.replaceAll("");
            receiptInfo.setTransDate(TransDate);
            if (TimeStamp != null && TimeStamp.length() > 0) {
                String[] tempStrings = TimeStamp.split("-");
                if (tempStrings.length > 3) {
                    String workdateString = tempStrings[0] + tempStrings[1] + tempStrings[2];
                    receiptInfo.setDetailDateTime(workdateString);
                } else {
                    receiptInfo.setDetailDateTime("");
                }
            } else {
                receiptInfo.setDetailDateTime("");
            }
            receiptInfoList.add(receiptInfo);
        }
        receiptResponse.setCompleteFlag(0);
        LocalDate requstDate = request.getStartDate();
        LocalDate now = LocalDate.now();
        LocalDate preDate = now.minusDays(1L);
        if (requstDate.compareTo(preDate) == -1) {
            receiptResponse.setCompleteFlag(1);
        }
        receiptResponse.setReceiptInfos(receiptInfoList);
        return receiptResponse;
    }

    private String Transformation(String pay) {
        StringBuilder newPay = new StringBuilder();
        int num = 0;
        if (pay.length() < 3) {
            newPay.append("0.");
            num = 3 - pay.length();
            for (int i = 1; i < num; ++i) {
                newPay.append("0");
            }
            newPay.append(pay);
        } else {
            for (int i = 0; i < pay.length(); ++i) {
                if (i == pay.length() - 3) {
                    newPay.append(pay.charAt(i)).append(".");
                    continue;
                }
                newPay.append(pay.charAt(i));
            }
        }
        return newPay.toString();
    }
}

