/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gzc.dc.services.detail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gzc.dc.services.detail.GZC_DC_Packer;
import kd.ebg.receipt.banks.gzc.dc.services.detail.GZC_DC_Parser;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public static final int PageSize = 10;

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getHeader().getAcnt();
        String accNo = acnt.getAccNo();
        Element root = GZC_DC_Packer.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"AC_NO", (String)accNo);
        String acctCcyCd = "CNY";
        JDomUtils.addChild((Element)body, (String)"ACCT_CCY_CD", (String)acctCcyCd);
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getEndDate(), (String)"yyyyMMdd"));
        String pageTag = this.getCurrentPage();
        if (StringUtils.isEmpty((String)pageTag) || "0".equalsIgnoreCase(pageTag)) {
            this.setCurrentPage(1);
        }
        JDomUtils.addChild((Element)body, (String)"PageIndex", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"PageSize", (String)String.valueOf(10));
        String encoding = EBContext.getContext().getCharsetName();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse response = new EBBankDetailResponse(this.parseDetails(request, responseStr));
        return response;
    }

    private List<DetailInfo> parseDetails(BankDetailRequest rqst, String rspStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse headRsp = GZC_DC_Parser.parseINFO(root);
        if (!"00000000".equals(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8d63\u5dde\u94f6\u884c\u54cd\u5e94\u7801:%s\u3002", (String)"DetailImpl_3", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]), headRsp.getResponseCode()) + String.format(ResManager.loadKDString((String)";\u51fa\u9519\u539f\u56e0\u4e3a:%s", (String)"DetailImpl_4", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = root.getChild("Body");
        String size = body.getChildTextTrim("Size");
        if ("0".equalsIgnoreCase(size)) {
            this.setLastPage(true);
            return detailList;
        }
        int page = Integer.parseInt(this.getCurrentPage()) + 1;
        this.setCurrentPage(page);
        if (StringUtils.isNotEmpty((String)size)) {
            if (Integer.parseInt(size) < 10) {
                this.setLastPage(true);
            } else {
                this.setLastPage(false);
            }
        } else {
            this.setLastPage(true);
        }
        Element tranList = body.getChild("List");
        List list = tranList.getChildren("Map");
        for (int i = 0; i < list.size(); ++i) {
            Element node = (Element)list.get(i);
            String refnbr = node.getChildTextTrim("REFNBR");
            String debitLndFlg = node.getChildTextTrim("DEBIT_LND_FLG");
            String amount = node.getChildTextTrim("Amount");
            String txCntptyAcctNum = node.getChildTextTrim("TX_CNTPTY_ACCT_NUM");
            DetailInfo detail = new DetailInfo();
            detail.setPayBankDetailSeqID(refnbr);
            detail.setExplanation(debitLndFlg);
            detail.setReceiptNo(refnbr);
            detail.setUseCN(amount);
            detail.setOppAccNo(txCntptyAcctNum);
            detailList.add(detail);
        }
        return detailList;
    }

    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "10000001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-receipt-banks-gzc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=utf-8");
    }
}

