/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.sjb.cms.service;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.sjb.cms.service.proxy.ProxyDownload;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    private static final String RECEIPTSEPERATOR = "_";
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String td = transDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        String tempBakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)("Temp" + LocalDateUtil.formatDate((LocalDate)transDate)));
        long taskId = request.getTaskId();
        String bankLogin = request.getBankLoginId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        downloadListDetails = downloadListDetails.stream().filter(detail -> detail.getFileName().toLowerCase(Locale.ENGLISH).endsWith(".zip")).collect(Collectors.toList());
        if (downloadListDetails.size() == 0) {
            return BankReceiptHandleResponseEB.fail();
        }
        ArrayList result = new ArrayList(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(0);
        String fileName = downloadListDetail.getFileLink();
        logger.info("\u4e0b\u8f7d\u6587\u4ef6\u540d\u4e3a" + fileName);
        String[] splitFileName = fileName.split("@");
        int recordNum = Integer.parseInt(splitFileName[1]);
        int fieldNum = Integer.parseInt(splitFileName[2]);
        String content = (String)new ProxyDownload().doBiz(BankReceiptRequest.builder().accNo(accNo).transDate(transDate).requestStr(splitFileName[0]).build()).getData();
        String[][] rs = BankReceiptDownloadImpl.parseMFS(content, recordNum, fieldNum);
        HashMap<String, String> receiptInfo = new HashMap<String, String>(8);
        for (String[] r : rs) {
            StringBuilder fn = new StringBuilder();
            String certNo = r[0].trim();
            String serialNo = r[2];
            String amount = r[8];
            String cdFlag = r[9];
            StringBuilder receipt_name = fn.append(accNo).append(RECEIPTSEPERATOR).append(td).append(RECEIPTSEPERATOR).append(amount).append(RECEIPTSEPERATOR).append(cdFlag).append(RECEIPTSEPERATOR).append(serialNo).append(".pdf");
            receiptInfo.put(certNo, receipt_name.toString());
        }
        if (this.download(downloadListDetail, tempBakFilePath, accNo, transDate, bankFtpProperties, sftp)) {
            if (!GZFileUtils.unZipFiles((String)(tempBakFilePath + File.separator + downloadListDetail.getFileName()), (String)tempBakFilePath)) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u538b\u7f29\u5305[%s]\u89e3\u538b\u7f29\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-sjb-cms", (Object[])new Object[0]), downloadListDetail.getFileName()));
            }
            RequestContextUtils.setZipName((String)downloadListDetail.getFileName());
            try (Stream<Path> paths = Files.walk(Paths.get(tempBakFilePath, new String[0]), new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(f -> {
                    logger.info(">>>\u6b63\u5728\u8bbf\u95ee\u7684\u6587\u4ef6\u540d\u4e3a{}", (Object)f.getName());
                    String newName = "";
                    for (Map.Entry curInfo : receiptInfo.entrySet()) {
                        logger.info("\u5f53\u524d\u904d\u5386\u7684\u662f " + (String)curInfo.getKey() + " " + (String)curInfo.getValue());
                        if (!f.getName().contains((CharSequence)curInfo.getKey())) continue;
                        newName = (String)curInfo.getValue();
                        break;
                    }
                    if (StringUtils.isEmpty((String)newName)) {
                        return;
                    }
                    logger.info("\u56de\u5355\u6587\u4ef6\u540d\u4e3a" + newName);
                    boolean isMove = FileCommonUtils.moveFile((File)f, (String)bakFilePath, (String)newName);
                    logger.info(">>>isMove\u7684\u503c\u4e3a{}", (Object)isMove);
                    if (isMove && f.getName().toLowerCase(Locale.ENGLISH).endsWith(".pdf")) {
                        logger.info(":)");
                        DownloadListDetail detail = new DownloadListDetail();
                        detail.setFileLink(newName);
                        detail.setFileName(newName);
                        result.add(detail);
                    }
                });
            }
            catch (IOException e) {
                logger.error("\u76db\u4eac\u94f6\u884c\u56de\u5355\u6587\u4ef6\u8f6c\u79fb\u5f02\u5e38\uff1a", (Throwable)e);
                throw new ReceiptException((Throwable)e);
            }
        }
        logger.info(">>>\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939");
        this.deleteDir(FileCommonUtils.getFileByPath((String)tempBakFilePath));
        logger.info(">>>>>>>>>\u76db\u4eac\u94f6\u884c-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, result.size()});
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, String bakFilePath, String accNo, LocalDate transDate, BankFtpProperties bankFtpProperties, ChannelSftp sftp) {
        String fileName = detail.getFileName();
        try {
            boolean flag = false;
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                String sftpPath = bankFtpProperties.getFtpPath();
                flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, fileName, bakFilePath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                flag = bankReceiptApiUtil.downloadReceiptFile(fileName, bakFilePath);
            }
            boolean bl = flag;
            return bl;
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        finally {
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
    }

    private void deleteDir(File file) {
        if (file.isFile()) {
            boolean isDelete = file.delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
        } else {
            File[] files = file.listFiles();
            if (files == null) {
                boolean isDelete = file.delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
            } else {
                for (int i = 0; i < files.length; ++i) {
                    this.deleteDir(files[i]);
                }
                boolean isDelete = file.delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u88ab\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
            }
        }
    }

    public static String[][] parseMFS(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "SJB_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u76db\u4eac\u94f6\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-sjb-cms", (Object[])new Object[0]);
    }
}

