/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.sjb.cms.service;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.sjb.cms.service.api.Receipt529761Impl;
import kd.ebg.receipt.banks.sjb.cms.service.api.Receipt529762Impl;
import kd.ebg.receipt.banks.sjb.cms.service.proxy.ProxyUpload;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDate + "\n");
        BankAcnt acnt = new BankAcnt();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        BankReceiptRequest req = this.buildReceiptRequest(acnt, transDate, "");
        BankReceiptResponseEB resp = new Receipt529761Impl().doBiz(req);
        Map data = (Map)resp.getData();
        String content = (String)data.get("content");
        String fileName = (String)data.get("fileName");
        String recordNum = (String)data.get("recordNum");
        String fieldNum = (String)data.get("fieldNum");
        if (StringUtils.isEmpty((String)fileName)) {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS"));
            fileName = timestamp + "_SJB_CMS.txt";
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("fileName", fileName);
            params.put("content", content);
            req.setParamsMap(params);
            new ProxyUpload().doBiz(req);
            logger.info("\u53d1\u9001\u6587\u4ef6\u5b8c\u6bd5");
            req.getParamsMap().clear();
        }
        req.setRequestStr(fileName);
        BankReceiptResponseEB responseEB = new Receipt529762Impl().doBiz(req);
        Object zipP = responseEB.getData();
        DownloadListDetail downloadListDetail = new DownloadListDetail();
        downloadListDetail.setFileLink(String.join((CharSequence)"@", Lists.newArrayList((Object[])new String[]{fileName, recordNum, fieldNum})));
        downloadListDetail.setFileName((String)zipP);
        result.add(downloadListDetail);
        return BankReceiptHandleResponseEB.success(result);
    }

    public BankReceiptRequest buildReceiptRequest(BankAcnt acnt, LocalDate localDate, String ext) {
        BankReceiptRequest req = BankReceiptRequest.builder().accNo(acnt.getAccNo()).transDate(localDate).requestStr(ext).build();
        BankHeader header = new BankHeader();
        header.setAcnt(acnt);
        req.setHeader(header);
        return req;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "SJB_BankReceiptFetchListAndDownloadTheList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-arcu-dc", (Object[])new Object[0]);
    }
}

